/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.Properties;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.resource.GalleryArb;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

public final class RootGalleryFolder
extends GalleryFolder
implements Dirtyable {
    private transient int _mainDividerLocation;
    private transient TreePath _selectedCategoryPath;
    private transient String _lastSelItem;
    private transient int _lastSelectedTab = -1;
    private transient boolean _showDescriptions;
    private transient boolean _dirty;
    private Properties _generators;
    private static final ElementAttributes _attributes = new ElementAttributes(ElementAttributes.OPEN_AS_TEXT);
    private static final String SHOW_ALL_DESCRIPTIONS_KEY = RootGalleryFolder.class.getName() + ".SHOW_ALL_DESCRIPTIONS";

    public RootGalleryFolder() {
        super(GalleryArb.getString((int)12));
    }

    public int getLastSelItem() {
        return -1;
    }

    public void setLastSelItem(int newItem) {
    }

    public String getLastSelectedItem() {
        return this._lastSelItem;
    }

    public void setLastSelectedItem(String newItem) {
        if (ModelUtil.areDifferent((Object)this._lastSelItem, (Object)newItem)) {
            this._lastSelItem = newItem;
        }
    }

    public Properties getGenerators() {
        return this._generators;
    }

    public void setGenerators(Properties prop) {
        this._generators = prop;
    }

    public int getLastSelCategory() throws TransientMarker {
        return -1;
    }

    public void setLastSelCategory(int newCategory) {
    }

    @Override
    public Attributes getAttributes() {
        return _attributes;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markDirty(boolean dirty) {
        this._dirty = dirty;
    }

    protected TreePath getSelectedCategoryPath() {
        return this._selectedCategoryPath;
    }

    protected void setSelectedCategoryPath(TreePath selectedCategoryPath) {
        if (ModelUtil.areDifferent((Object)selectedCategoryPath, (Object)this._selectedCategoryPath)) {
            this._selectedCategoryPath = selectedCategoryPath;
        }
    }

    protected int getMainDividerLocation() {
        return this._mainDividerLocation;
    }

    protected void setMainDividerLocation(int mainDividerLocation) {
        this._mainDividerLocation = mainDividerLocation;
    }

    @Deprecated
    protected int getItemDividerLocation() {
        return -1;
    }

    @Deprecated
    protected void setItemDividerLocation(int itemDividerLocation) {
    }

    protected void setLastSelectedTab(int lastSelectedTab) {
        this._lastSelectedTab = lastSelectedTab;
    }

    protected int getLastSelectedTab() {
        return this._lastSelectedTab;
    }

    protected void setShowDescriptions(boolean showDescriptions) {
        if (this._showDescriptions != showDescriptions) {
            this._showDescriptions = showDescriptions;
            DTCache dtCache = Ide.getDTCache();
            dtCache.putBoolean(SHOW_ALL_DESCRIPTIONS_KEY, this._showDescriptions);
        }
    }

    protected boolean isShowDescriptions() {
        DTCache dtCache = Ide.getDTCache();
        this._showDescriptions = dtCache.getBoolean(SHOW_ALL_DESCRIPTIONS_KEY, false);
        return this._showDescriptions;
    }

    protected GalleryFolder getFolder(String categoryName, String folderName) {
        RootGalleryFolder f = categoryName != null ? this.getFolder(categoryName) : this;
        return f != null ? f.getFolder(folderName) : null;
    }

    protected GalleryFolder createFolder(String categoryName, String folderName) {
        RootGalleryFolder f = categoryName != null ? this.createFolder(categoryName) : this;
        return f.createFolder(folderName);
    }

    GalleryFolder getFolder(String[] path) {
        GalleryFolder f = this;
        for (int i = 0; i < path.length; ++i) {
            if ((f = f.getFolder(path[i])) != null) continue;
            return null;
        }
        return f;
    }

    GalleryFolder createFolder(String[] path) {
        GalleryFolder f = this;
        GalleryFolder owner = f.findFolder(path[path.length - 1]);
        if (owner != null) {
            if (path.length >= 2) {
                GalleryFolder parent = f.findFolder(path[0]);
                if (parent != null && parent.containsChild((Element)owner)) {
                    return owner;
                }
            } else {
                return owner;
            }
        }
        for (int i = 0; i < path.length; ++i) {
            if ((f = f.createFolder(path[i])) != null) continue;
            return null;
        }
        return f;
    }
}

