/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GallerySearchEvent;
import oracle.ide.gallery.GallerySearchListener;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.natives.accessibility.HighContrast;
import oracle.ide.nulls.NullIcon;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

final class ObjectGalleryPanel
extends JPanel {
    private boolean _forciblyHideDescriptions = Boolean.parseBoolean(System.getProperty("hide-gallery-descriptions"));
    private static final String SHOW_TECHSCOPE_PROPERTIES_KEY = "show-tech-scope-project-properties";
    private static final Icon NULL_ICON = new NullIcon();
    private static final double MAIN_SPLITTER_RESIZE_WEIGHT = 0.33;
    private static final Border UNDERLINE_BORDER = JavatoolsBorderFactory.createBottomBorder((Color)SystemColor.controlShadow);
    private static final boolean HIGH_CONTRAST = HighContrast.isHighContrastModeEnabled();
    final SearchField searchField = new SearchField();
    final JPanel searchPanel = new JPanel();
    final JSplitPane splitPane = new JSplitPane(1, true);
    final JLabel lblCat = new JLabel();
    final JLabel lblItems = new JLabel();
    final JCheckBox chkShowAllDescriptions = new JCheckBox();
    final JLabel lblDescription = new JLabel();
    final JScrollPane jspTreeCat = new JScrollPane();
    final JScrollPane jspListItems = new JScrollPane(20, 31);
    final JPanel itemsListHeaderPanel = new JPanel();
    final JPanel itemsContainerPanel = new JPanel();
    final JTable tableItems = new JTable();
    final JTree treeCat = new JTree();
    final GridBagLayout gridBagLayout1 = new GridBagLayout();
    final BorderLayout borderLayout = new BorderLayout(5, 10);
    final RichHintLabel techscopeLink = new RichHintLabel();
    final NoResultsFoundPanel expandSearchPanel;
    private String _title;
    private RootGalleryFolder _model;
    private Context _context;
    private TreeModel _treeModel;
    private AllItemsFolder _allItemsFolder;
    private boolean _filterByTechnology;
    private boolean _explicitInitialSel;
    private boolean _persistLastSelectionIndex = true;
    private final transient Map<GalleryElement, String> _elementParentMap = new HashMap<GalleryElement, String>();

    ObjectGalleryPanel(RootGalleryFolder model, Context context) {
        this(model, context, false);
    }

    ObjectGalleryPanel(RootGalleryFolder model, Context context, boolean filterByTechnology) {
        this(model, context, filterByTechnology, null);
    }

    ObjectGalleryPanel(RootGalleryFolder model, Context context, boolean filterByTechnology, GallerySearchListener searchListener) {
        this._model = model;
        this._context = context;
        this._filterByTechnology = filterByTechnology;
        this.setName(filterByTechnology ? "NormalGalleryPanel" : "FilteredGalleryPanel");
        this.expandSearchPanel = new NoResultsFoundPanel(searchListener);
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.setPreferredSize(new Dimension(450, 300));
        ResourceUtils.resButton((AbstractButton)this.chkShowAllDescriptions, (String)GalleryArb.getString((int)9));
        ResourceUtils.resLabel((JLabel)this.lblCat, (Component)this.treeCat, (String)GalleryArb.getString((int)7));
        ResourceUtils.resLabel((JLabel)this.lblItems, (Component)this.tableItems, (String)GalleryArb.getString((int)10));
        this.searchField.setName("SearchField");
        this.searchField.setStyle(SearchField.Style.FILTER);
        this.searchField.setPrompt(GalleryArb.getString((int)8));
        this.searchField.setKeyEventTargetComponent((Component)this.treeCat);
        this.searchPanel.setLayout(new GridBagLayout());
        this.expandSearchPanel.setName("NoResultsFound");
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridy = 0;
        g.gridx = 1;
        g.weightx = 0.5;
        g.fill = 2;
        g.weightx = 1.0;
        this.searchPanel.add((Component)this.searchField, g);
        ++g.gridx;
        this.searchPanel.add((Component)Box.createHorizontalBox(), g);
        ++g.gridx;
        this.treeCat.setName("CategoryList");
        this.treeCat.setExpandsSelectedPaths(true);
        this.treeCat.setRootVisible(false);
        this.treeCat.setShowsRootHandles(true);
        this.treeCat.setScrollsOnExpand(true);
        this.treeCat.getSelectionModel().setSelectionMode(1);
        this.jspTreeCat.setBorder(null);
        this.jspTreeCat.setColumnHeaderView(this.lblCat);
        this.jspTreeCat.setViewportView(this.treeCat);
        this.tableItems.setName("ItemsList");
        this.tableItems.setBorder(null);
        this.tableItems.setShowGrid(false);
        this.tableItems.setAutoscrolls(true);
        this.tableItems.setOpaque(true);
        this.tableItems.setBackground(Color.WHITE);
        this.tableItems.setTableHeader(null);
        this.tableItems.setColumnSelectionAllowed(false);
        this.tableItems.setSelectionMode(0);
        this.lblCat.setBorder(BorderFactory.createCompoundBorder(UNDERLINE_BORDER, BorderFactory.createEmptyBorder(3, 2, 3, 2)));
        this.jspListItems.setName("JSPItemsList");
        this.jspListItems.setBorder(BorderFactory.createEmptyBorder());
        this.jspListItems.getViewport().setBackground(Color.WHITE);
        this.splitPane.setName("ItemsListSplitPane");
        this.splitPane.setResizeWeight(0.33);
        this.itemsListHeaderPanel.setLayout(new GridBagLayout());
        this.itemsListHeaderPanel.setBorder(BorderFactory.createCompoundBorder(UNDERLINE_BORDER, BorderFactory.createEmptyBorder(1, 2, 1, 2)));
        this.itemsListHeaderPanel.add((Component)this.lblItems, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.itemsListHeaderPanel.add((Component)this.chkShowAllDescriptions, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.itemsContainerPanel.setLayout(new BorderLayout());
        this.itemsContainerPanel.setBorder(null);
        this.itemsContainerPanel.setOpaque(true);
        this.itemsContainerPanel.setBackground(SystemColor.WHITE);
        this.itemsContainerPanel.add((Component)this.itemsListHeaderPanel, "North");
        this.jspListItems.setViewportView(this.tableItems);
        this.itemsContainerPanel.add((Component)this.jspListItems, "Center");
        this.splitPane.setLeftComponent(this.jspTreeCat);
        this.splitPane.setRightComponent(this.itemsContainerPanel);
        if (this.hasProjectContext() && !this.isAllScope()) {
            this.techscopeLink.setName("TechScopesLink");
            this.techscopeLink.registerAction(SHOW_TECHSCOPE_PROPERTIES_KEY, (Action)new TechScopesLinkAction(SHOW_TECHSCOPE_PROPERTIES_KEY));
            this.techscopeLink.setHtmlText(GalleryArb.getString((int)16));
            JPanel panel = new JPanel(new BorderLayout(0, 10));
            panel.add((Component)this.techscopeLink, "North");
            panel.add((Component)this.searchPanel, "Center");
            this.add((Component)panel, "North");
        } else {
            this.add((Component)this.searchPanel, "North");
        }
        this.add((Component)this.splitPane, "Center");
    }

    private void postInit() {
        this.treeCat.setCellRenderer(new CategoryTreeCellRenderer());
        this.tableItems.setDefaultRenderer(GalleryElement.class, new ItemTableCellRenderer(this._model.isShowDescriptions()));
        this.chkShowAllDescriptions.setSelected(this._model.isShowDescriptions());
        EventListener listener = new EventListener();
        this.addHierarchyListener(listener);
        this.tableItems.getSelectionModel().addListSelectionListener(listener);
        this.tableItems.addMouseListener(listener);
        this.treeCat.addTreeSelectionListener(listener);
        this.treeCat.addTreeExpansionListener(listener);
        this.searchField.addSearchListener((SearchListener)listener);
        this.chkShowAllDescriptions.addItemListener(listener);
        this.jspListItems.getViewport().addComponentListener(listener);
        this.initTitle();
        this.rebuildGallery();
        this.installKeyHandler();
        ToolTipManager.sharedInstance().registerComponent(this.treeCat);
    }

    private void installKeyHandler() {
        InputMap inputMap = this.tableItems.getInputMap(0);
        String actionMapKey = "nextBackEnter";
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "nextBackEnter");
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "nextBackEnter");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "nextBackEnter");
        this.tableItems.getActionMap().put("nextBackEnter", new TableKeyboardAction());
    }

    private TreeModel createTreeModel() {
        ArrayList<GalleryElement> allElements = new ArrayList<GalleryElement>();
        GalleryTreeNode root = new GalleryTreeNode(this._model, allElements);
        this._allItemsFolder = new AllItemsFolder(allElements);
        root.add(new GalleryTreeNode(this._allItemsFolder, null));
        this._treeModel = new DefaultTreeModel(root);
        return this._treeModel;
    }

    private void initTitle() {
        String name = this.hasProjectContext() ? (this._filterByTechnology ? GalleryArb.getString((int)15) : GalleryArb.getString((int)14)) : GalleryArb.getString((int)17);
        this.setTitle(name);
    }

    private GalleryFolder getGalleryFolder(TreePath path) {
        if (path == null) {
            return null;
        }
        Object lastPath = path.getLastPathComponent();
        if (!(lastPath instanceof GalleryTreeNode)) {
            return null;
        }
        GalleryTreeNode treeNode = (GalleryTreeNode)lastPath;
        return treeNode.getGalleryFolder();
    }

    private void restoreTreeExpansion() {
        boolean autoExpand = !this.isAllScope();
        GalleryTreeNode root = this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            GalleryTreeNode node = (GalleryTreeNode)e.nextElement();
            GalleryFolder folder = node.getGalleryFolder();
            if (!autoExpand && !folder.isExpanded()) continue;
            this.treeCat.expandPath(new TreePath(node.getPath()));
        }
    }

    private boolean restoreTreeSelection(TreePath selectedPath) {
        GalleryFolder selectedFolder = this.getGalleryFolder(selectedPath);
        if (selectedFolder instanceof AllItemsFolder) {
            TreePath path = new TreePath(new Object[]{this.getRoot(), this.getRoot().getLastChild()});
            this.treeCat.setSelectionPath(path);
            this.treeCat.scrollPathToVisible(path);
            return true;
        }
        GalleryTreeNode root = this.getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            GalleryTreeNode next = (GalleryTreeNode)e.nextElement();
            if (selectedFolder != next.getUserObject()) continue;
            TreePath path = new TreePath(next.getPath());
            this.treeCat.setSelectionPath(path);
            this.treeCat.scrollPathToVisible(path);
            return true;
        }
        this.treeCat.setSelectionRow(0);
        return false;
    }

    private GalleryTreeNode getRoot() {
        return (GalleryTreeNode)this._treeModel.getRoot();
    }

    public void setContext(Context context) {
        this._context = context;
    }

    @Deprecated
    public void setInitialSelection(String wizName) {
        this.setInitialSelection(null, wizName);
    }

    protected void setInitialSelection(String folderName, String wizName) {
        GalleryFolder folder;
        GalleryTreeNode next;
        Enumeration<TreeNode> e;
        GalleryTreeNode root = this.getRoot();
        if (folderName != null) {
            this._explicitInitialSel = true;
            e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                next = (GalleryTreeNode)e.nextElement();
                folder = (GalleryFolder)next.getUserObject();
                if (!folderName.equals(folder.getName())) continue;
                TreePath treePath = new TreePath(next.getPath());
                this.treeCat.setSelectionPath(treePath);
                this.treeCat.scrollPathToVisible(treePath);
                if (this.tableItems.getModel().getRowCount() > 0) {
                    this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
                }
                root = next;
                break;
            }
        }
        if (wizName != null) {
            this._explicitInitialSel = true;
            e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                GalleryElement[] elements;
                next = (GalleryTreeNode)e.nextElement();
                folder = (GalleryFolder)next.getUserObject();
                for (GalleryElement elem : elements = folder.getElementChildren()) {
                    String elemWiz = elem.getWizardClass();
                    if (!wizName.equals(elemWiz)) continue;
                    this.treeCat.setSelectionPath(new TreePath(next.getPath()));
                    for (int i = 0; i < this.tableItems.getRowCount(); ++i) {
                        if (!elem.equals(this.tableItems.getValueAt(i, 0))) continue;
                        this.tableItems.getSelectionModel().setSelectionInterval(i, i);
                        break;
                    }
                    return;
                }
            }
        }
    }

    GalleryElement getSelectedItem() {
        int row = this.tableItems.getSelectedRow();
        if (row != -1) {
            return (GalleryElement)this.tableItems.getValueAt(row, 0);
        }
        return null;
    }

    void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    int getMainDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    @Deprecated
    int getItemDividerLocation() {
        return -1;
    }

    void shouldRefresh() {
        TreePath selectedPath;
        this.chkShowAllDescriptions.setSelected(this._model.isShowDescriptions());
        if (!this._explicitInitialSel && (selectedPath = this._model.getSelectedCategoryPath()) != null && !this.treeCat.getSelectionPath().equals(selectedPath) && this.restoreTreeSelection(selectedPath)) {
            this._persistLastSelectionIndex = true;
            this.restoreLastSelectedItem();
        }
    }

    private void restoreLastSelectedItem() {
        String savedItem = this._model.getLastSelectedItem();
        int rowCount = this.tableItems.getModel().getRowCount();
        boolean tryRestore = ModelUtil.hasLength((String)savedItem);
        if (tryRestore) {
            for (int i = 0; i < rowCount; ++i) {
                GalleryElement galleryItem = (GalleryElement)this.tableItems.getValueAt(i, 0);
                if (!ModelUtil.areEqual((Object)galleryItem.getName(), (Object)savedItem)) continue;
                this.tableItems.getSelectionModel().setSelectionInterval(i, i);
                this.scrollTableToSelectedRow();
                return;
            }
        }
        if (rowCount > 0 && this.tableItems.getSelectedRowCount() == 0) {
            if (tryRestore) {
                this._persistLastSelectionIndex = false;
            }
            this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void persistLastSelectedItem() {
        GalleryElement element = this.getSelectedItem();
        if (element != null) {
            this._model.setLastSelectedItem(element.getName());
        }
    }

    private void setShowAllDescriptions(boolean showAllDescriptions) {
        this._model.setShowDescriptions(showAllDescriptions);
    }

    private boolean isShowAllDescriptions() {
        return this._model.isShowDescriptions();
    }

    private boolean isAllScope() {
        return !this._filterByTechnology;
    }

    private TechnologyScope getScope() {
        return !this.isAllScope() ? this.getProjectScope() : null;
    }

    private TechnologyScope getProjectScope() {
        if (this._context == null) {
            return null;
        }
        Project project = this._context.getProject();
        return project != null ? TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope() : null;
    }

    private boolean hasProjectScope() {
        TechnologyScope scope = this.getProjectScope();
        return scope != null && !scope.isEmpty();
    }

    private boolean hasProjectContext() {
        return this._context != null && this._context.getProject() != null;
    }

    private void rebuildGallery() {
        this.treeCat.setModel(this.createTreeModel());
        if (this.treeCat.getRowCount() > 0) {
            TreePath selectedPath = this._model.getSelectedCategoryPath();
            if (selectedPath != null) {
                this.restoreTreeExpansion();
                this._persistLastSelectionIndex = this.restoreTreeSelection(selectedPath);
            } else {
                IdeUtil.expandAllTreeRows((JTree)this.treeCat);
                this.treeCat.setSelectionRow(0);
            }
        }
        this.restoreLastSelectedItem();
    }

    private void scrollTableToSelectedRow() {
        int row = this.tableItems.getSelectedRow();
        Rectangle rect = this.tableItems.getCellRect(row, 0, true);
        this.tableItems.scrollRectToVisible(rect);
    }

    private String getParentFolderFor(GalleryElement element) {
        if (this._elementParentMap.containsKey(element)) {
            return this._elementParentMap.get(element);
        }
        return "";
    }

    void setTitle(String _title) {
        this._title = _title;
    }

    String getTitle() {
        return this._title;
    }

    private void fireInvokeWizardAction(GalleryElement element) {
        Wizard wiz = element.getWizard();
        if (null != wiz) {
            this.fireActionPerformed(wiz);
        } else {
            String message = GalleryArb.getString((int)1);
            boolean mType = false;
            String title = GalleryArb.getString((int)0);
            IdeMainWindow mainFrame = Ide.getMainWindow();
            JOptionPane.showMessageDialog((Component)mainFrame, message, title, 0);
        }
    }

    private void fireActionPerformed(Wizard event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        String actionCommand = "ITEM_INVOKED";
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(event, 1001, actionCommand, 0);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    private class TableKeyboardAction
    extends AbstractAction {
        private TableKeyboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JTable table = (JTable)ae.getSource();
            String actionCommand = ae.getActionCommand();
            boolean tab = actionCommand.equals("\t");
            boolean enter = actionCommand.equals("\n");
            if (tab && (ae.getModifiers() & 1) == 1) {
                tab = false;
            }
            if (enter) {
                GalleryElement element = ObjectGalleryPanel.this.getSelectedItem();
                if (element != null) {
                    ObjectGalleryPanel.this.fireInvokeWizardAction(element);
                }
            } else if (tab) {
                table.transferFocus();
            } else {
                table.transferFocusBackward();
            }
        }
    }

    private class TechScopesLinkAction
    extends AbstractAction {
        TechScopesLinkAction(String id) {
            super(id);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ObjectGalleryPanel.this._context != null && ObjectGalleryPanel.this._context.getProject() != null) {
                TechnologyScope currentScope = ObjectGalleryPanel.this.getProjectScope();
                ProjectPropertiesDialog.showDialog((Context)ObjectGalleryPanel.this._context, (Frame)Ide.getMainWindow(), (Project)ObjectGalleryPanel.this._context.getProject(), (String[])new String[]{"Technology Scope"});
                if (!currentScope.equals((Object)ObjectGalleryPanel.this.getProjectScope())) {
                    ObjectGalleryPanel.this.rebuildGallery();
                }
            }
        }
    }

    private class AllItemsFolder
    extends GalleryFolder {
        private String searchText;

        AllItemsFolder(List<GalleryElement> children) {
            this.setList(children);
        }

        @Override
        public Icon getIcon() {
            return OracleIcons.getIcon((String)"new.png");
        }

        @Override
        public String getShortLabel() {
            return GalleryArb.getString((int)18);
        }

        @Override
        public String getName() {
            return this.getShortLabel();
        }

        @Override
        public String getLongLabel() {
            return this.getShortLabel();
        }

        @Override
        protected final GalleryElement[] getElementChildren() {
            GalleryElement[] elements = super.getElementChildren();
            if (this.getSearchText() != null && this.getSearchText().length() > 0) {
                ArrayList<GalleryElement> list = new ArrayList<GalleryElement>();
                Pattern pattern = Pattern.compile(this.getSearchText(), 2);
                for (GalleryElement element : elements) {
                    if (!pattern.matcher(element.getShortLabel()).find() && !pattern.matcher(ObjectGalleryPanel.this.getParentFolderFor(element)).find() && !pattern.matcher(Arrays.toString(element.getTechnologyKeys())).find()) continue;
                    list.add(element);
                }
                return list.toArray(new GalleryElement[list.size()]);
            }
            return elements;
        }

        void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        String getSearchText() {
            return this.searchText;
        }

        @Override
        protected final GalleryElement[] getSortedElementChildren() {
            GalleryElement[] children = this.getElementChildren();
            Arrays.sort(children, GalleryElement.LABEL_ONLY_COMPARATOR);
            return children;
        }
    }

    private final class GalleryTableModel
    extends AbstractTableModel {
        final GalleryFolder _folder;
        final List<GalleryElement> _elements;

        public GalleryTableModel(GalleryFolder folder) {
            this._folder = folder;
            if (folder == null) {
                this._elements = Collections.emptyList();
            } else {
                this._elements = new ArrayList<GalleryElement>();
                this.refreshElements();
            }
        }

        private void refreshElements() {
            if (this._folder != null) {
                GalleryElement[] children;
                this._elements.clear();
                for (GalleryElement e : children = this._folder.getSortedElementChildren()) {
                    try {
                        if (!ModelUtil.hasLength((String)e.getShortLabel()) || !this.isAvailable(e)) continue;
                        this._elements.add(e);
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            return GalleryElement.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this._elements.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= 0 && row < this._elements.size()) {
                return this._elements.get(row);
            }
            return null;
        }

        private boolean isAvailable(GalleryElement e) {
            if (ObjectGalleryPanel.this.isAllScope()) {
                return true;
            }
            return ObjectGalleryPanel.this.hasProjectContext() ? e.isInScope(ObjectGalleryPanel.this.getScope()) : e.isAvailable(ObjectGalleryPanel.this._context);
        }

        @Override
        public void fireTableDataChanged() {
            this.refreshElements();
            super.fireTableDataChanged();
        }

        GalleryElement[] getGalleryElements() {
            return this._elements.toArray(new GalleryElement[this._elements.size()]);
        }
    }

    private final class GalleryTreeNode
    extends DefaultMutableTreeNode {
        public GalleryTreeNode(GalleryFolder folder, List<GalleryElement> children) {
            super(folder);
            Object[] folders = folder.getFolderChildren();
            Arrays.sort(folders);
            for (int i = 0; i < folders.length; ++i) {
                Object f = folders[i];
                if (!this.isAvailable((GalleryFolder)f)) continue;
                this.add(new GalleryTreeNode((GalleryFolder)f, children));
                if (children == null) continue;
                for (GalleryElement child : ((GalleryFolder)f).getElementChildren()) {
                    if (ObjectGalleryPanel.this._elementParentMap.containsKey(child)) continue;
                    String folderLabel = ((GalleryFolder)f).toString();
                    ObjectGalleryPanel.this._elementParentMap.put(child, folderLabel);
                    children.add(child);
                }
            }
        }

        private boolean isAvailable(GalleryFolder f) {
            if (ObjectGalleryPanel.this.isAllScope()) {
                return true;
            }
            return ObjectGalleryPanel.this.hasProjectContext() ? f.isInScope(ObjectGalleryPanel.this.getScope()) : f.isAvailable(ObjectGalleryPanel.this._context);
        }

        private GalleryFolder getGalleryFolder() {
            return (GalleryFolder)this.getUserObject();
        }
    }

    private final class EventListener
    implements ComponentListener,
    ItemListener,
    HierarchyListener,
    ListSelectionListener,
    MouseListener,
    SearchListener,
    TreeExpansionListener,
    TreeSelectionListener {
        private volatile int _selectedItemTracker;

        private EventListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ObjectGalleryPanel.this.scrollTableToSelectedRow();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            boolean showDescriptions = checkBox.isSelected();
            ObjectGalleryPanel.this.setShowAllDescriptions(showDescriptions);
            ItemTableCellRenderer oldRenderer = (ItemTableCellRenderer)ObjectGalleryPanel.this.tableItems.getDefaultRenderer(GalleryElement.class);
            ItemTableCellRenderer newRenderer = new ItemTableCellRenderer(showDescriptions);
            newRenderer.setShowCategory(oldRenderer._showItemCategory);
            GalleryTableModel model = (GalleryTableModel)ObjectGalleryPanel.this.tableItems.getModel();
            int row = ObjectGalleryPanel.this.tableItems.getSelectedRow();
            ObjectGalleryPanel.this.tableItems.setModel(new DefaultTableModel());
            ObjectGalleryPanel.this.tableItems.setDefaultRenderer(GalleryElement.class, newRenderer);
            ObjectGalleryPanel.this.tableItems.setModel(model);
            ObjectGalleryPanel.this.tableItems.getSelectionModel().setSelectionInterval(row, row);
            ObjectGalleryPanel.this.scrollTableToSelectedRow();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent event) {
            ObjectGalleryPanel panel;
            if ((event.getChangeFlags() & 4L) != 0L && (panel = (ObjectGalleryPanel)event.getSource()).isShowing()) {
                int mainDividerLocation = ObjectGalleryPanel.this._model.getMainDividerLocation();
                if (mainDividerLocation != 0) {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(mainDividerLocation);
                } else {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(ObjectGalleryPanel.this.splitPane.getResizeWeight());
                }
                ObjectGalleryPanel.this.removeHierarchyListener(this);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!ObjectGalleryPanel.this._explicitInitialSel && ObjectGalleryPanel.this._persistLastSelectionIndex) {
                ObjectGalleryPanel.this.persistLastSelectedItem();
            }
            ObjectGalleryPanel.this._persistLastSelectionIndex = true;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                int row = ObjectGalleryPanel.this.tableItems.getSelectedRow();
                if (e.getClickCount() == 2) {
                    Object value;
                    if (row == this._selectedItemTracker && (value = ObjectGalleryPanel.this.tableItems.getModel().getValueAt(row, 0)) instanceof GalleryElement) {
                        GalleryElement element = (GalleryElement)value;
                        ObjectGalleryPanel.this.fireInvokeWizardAction(element);
                    }
                } else if (e.getClickCount() == 1) {
                    this._selectedItemTracker = row;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            if (ObjectGalleryPanel.this.isAllScope()) {
                GalleryFolder folder = ObjectGalleryPanel.this.getGalleryFolder(e.getPath());
                folder.setExpanded(true);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            if (ObjectGalleryPanel.this.isAllScope()) {
                GalleryFolder folder = ObjectGalleryPanel.this.getGalleryFolder(e.getPath());
                folder.setExpanded(false);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath();
            GalleryFolder selFolder = ObjectGalleryPanel.this.getGalleryFolder(selectedPath);
            GalleryTableModel model = new GalleryTableModel(selFolder);
            ObjectGalleryPanel.this.tableItems.setModel(model);
            ItemTableCellRenderer tableCellRenderer = (ItemTableCellRenderer)ObjectGalleryPanel.this.tableItems.getDefaultRenderer(GalleryElement.class);
            tableCellRenderer.setShowCategory(selFolder == ObjectGalleryPanel.this._allItemsFolder);
            if (!ObjectGalleryPanel.this.treeCat.isShowing()) {
                return;
            }
            this.makeTableVisible();
            if (!ObjectGalleryPanel.this._explicitInitialSel) {
                ObjectGalleryPanel.this._model.setSelectedCategoryPath(selectedPath);
                ObjectGalleryPanel.this.persistLastSelectedItem();
            }
        }

        public void searchPerformed(SearchEvent se) {
            TreePath selectedPath;
            GalleryFolder selFolder;
            if (se.getSearchText().length() > 0 && (selFolder = ObjectGalleryPanel.this.getGalleryFolder(selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath())) != ObjectGalleryPanel.this._allItemsFolder) {
                TreePath path = new TreePath(new Object[]{ObjectGalleryPanel.this.getRoot(), ObjectGalleryPanel.this.getRoot().getLastChild()});
                ObjectGalleryPanel.this.treeCat.setSelectionPath(path);
                ObjectGalleryPanel.this.treeCat.scrollPathToVisible(path);
                ObjectGalleryPanel.this.tableItems.setModel(new GalleryTableModel(ObjectGalleryPanel.this._allItemsFolder));
            }
            if ((selFolder = ObjectGalleryPanel.this.getGalleryFolder(selectedPath = ObjectGalleryPanel.this.treeCat.getSelectionPath())) == ObjectGalleryPanel.this._allItemsFolder) {
                ObjectGalleryPanel.this._allItemsFolder.setSearchText(se.getSearchText());
                GalleryTableModel tableModel = (GalleryTableModel)ObjectGalleryPanel.this.tableItems.getModel();
                Object[] preSearchElems = tableModel.getGalleryElements();
                Object[] postSearchElems = ObjectGalleryPanel.this._allItemsFolder.getSortedElementChildren();
                if (!Arrays.equals(preSearchElems, postSearchElems)) {
                    tableModel.fireTableDataChanged();
                }
                if (tableModel.getRowCount() > 0) {
                    ObjectGalleryPanel.this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
                    this.makeTableVisible();
                } else {
                    this.makeExpandSearchPanelVisible();
                }
            }
        }

        private void makeTableVisible() {
            if (ObjectGalleryPanel.this.tableItems.getModel().getRowCount() > 0) {
                ObjectGalleryPanel.this.tableItems.getSelectionModel().setSelectionInterval(0, 0);
            }
            ObjectGalleryPanel.this.jspListItems.setViewportView(ObjectGalleryPanel.this.tableItems);
        }

        private void makeExpandSearchPanelVisible() {
            ObjectGalleryPanel.this.tableItems.getSelectionModel().clearSelection();
            ObjectGalleryPanel.this.jspListItems.setViewportView(ObjectGalleryPanel.this.expandSearchPanel);
        }

        public void searchCategoryChanged(SearchEvent se) {
        }
    }

    private static final class CategoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CategoryTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            this.setToolTipText(this.getText());
            return this;
        }
    }

    public final class ItemTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final Color hc_listForeground;
        private final Color hc_selectionHighlightColor;
        private final Color hc_inactiveText;
        private final Color hc_selectionHighlightBackground;
        private final Color hc_listBackground;
        private final Color descriptionForegroundColor;
        private final Color selectionHighlightColor;
        private final Color bandingBackgroundColor;
        private final Border descriptionBorder;
        private final Border bottomOnlyBorder;
        private final JLabel _header;
        private final JLabel _headerDetail;
        private final JTextArea _description;
        private boolean _showAllDescriptions;
        private boolean _showItemCategory;
        private AccessibleContext _accessibleContext;
        private GridBagConstraints _constraints;

        ItemTableCellRenderer(boolean showDescriptions) {
            super(new GridBagLayout());
            this.hc_listForeground = UIManager.getColor("List.foreground");
            this.hc_selectionHighlightColor = UIManager.getColor("List.selectionForeground");
            this.hc_inactiveText = UIManager.getColor("textInactiveText");
            this.hc_selectionHighlightBackground = UIManager.getColor("List.selectionBackground");
            this.hc_listBackground = UIManager.getColor("List.background");
            this.descriptionForegroundColor = Colors.HINT_TEXT;
            this.selectionHighlightColor = new Color(216, 236, 253);
            this.bandingBackgroundColor = new Color(250, 250, 250);
            this.descriptionBorder = BorderFactory.createEmptyBorder(0, 20, 0, 5);
            this.bottomOnlyBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 204)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._header = new JLabel();
            this._headerDetail = new JLabel();
            this._description = new JTextArea();
            this._constraints = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 5, 0);
            this.setBorder(this.bottomOnlyBorder);
            this._showAllDescriptions = showDescriptions;
            this._description.setBorder(this.descriptionBorder);
            this._description.setFont(this._header.getFont());
            this._description.setEditable(false);
            this._description.setOpaque(false);
            this._description.setLineWrap(true);
            this._description.setWrapStyleWord(true);
            this.add((Component)this._header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 5, 0));
            this.add((Component)this._headerDetail, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 5), 5, 0));
            this.add((Component)this._description, this._constraints);
            this.add((Component)Box.createHorizontalBox(), new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof GalleryElement) {
                GalleryElement element = (GalleryElement)value;
                Icon enabledIcon = element.getIcon();
                Icon disabledIcon = element.getDisabledIcon();
                this._header.setIcon(enabledIcon != null ? enabledIcon : NULL_ICON);
                this._header.setDisabledIcon(disabledIcon != null ? disabledIcon : NULL_ICON);
                this._header.setText(element.getShortLabel());
                this._header.setFont(this._header.getFont().deriveFont(isSelected ? 1 : 0));
                boolean enabled = element.isAvailable(ObjectGalleryPanel.this._context) && table.isEnabled();
                this._header.setEnabled(enabled);
                if (this._showItemCategory) {
                    this._headerDetail.setText(String.format("(%s)", ObjectGalleryPanel.this.getParentFolderFor(element)));
                    this._headerDetail.setEnabled(this._header.isEnabled());
                } else {
                    this._headerDetail.setText("");
                }
                this._description.setText(element.getLongLabel());
                if (!ObjectGalleryPanel.this._forciblyHideDescriptions && (isSelected || this._showAllDescriptions)) {
                    this._description.setEnabled(enabled);
                    this.add((Component)this._description, this._constraints);
                } else {
                    this._description.setText("");
                    this.remove(this._description);
                }
                this.colorControls(row, enabled, isSelected);
                int prefHeight = this.getPreferredSize().height;
                if (prefHeight != table.getRowHeight(row)) {
                    int adjustedHeight = Math.min(prefHeight, 180);
                    table.setRowHeight(row, adjustedHeight);
                }
            }
            return this;
        }

        private void colorControls(int row, boolean isEnabled, boolean isSelected) {
            if (HIGH_CONTRAST) {
                Color fg = isEnabled ? (isSelected ? this.hc_selectionHighlightColor : this.hc_listForeground) : this.hc_inactiveText;
                this._header.setForeground(fg);
                this._headerDetail.setForeground(fg);
                this._description.setForeground(fg);
                this.setBackground(isSelected ? this.hc_selectionHighlightBackground : this.hc_listBackground);
            } else {
                this._description.setForeground(isSelected ? SystemColor.BLACK : this.descriptionForegroundColor);
                Color bgcolor = row % 2 == 0 ? SystemColor.WHITE : this.bandingBackgroundColor;
                this.setBackground(isSelected ? this.selectionHighlightColor : bgcolor);
            }
        }

        public String getText() {
            return this._header.getText() + " " + this._description.getText();
        }

        void setShowCategory(boolean show) {
            this._showItemCategory = show;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this._accessibleContext == null) {
                this._accessibleContext = new AccessibleItemTableCellRenderer();
            }
            return this._accessibleContext;
        }

        private class AccessibleItemTableCellRenderer
        extends JComponent.AccessibleJComponent {
            private AccessibleItemTableCellRenderer() {
                super(ItemTableCellRenderer.this);
            }

            @Override
            public String getAccessibleName() {
                return ItemTableCellRenderer.this._header.getText() + "\n" + ItemTableCellRenderer.this._description.getText();
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            @Override
            public int getAccessibleChildrenCount() {
                return 1;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                return ItemTableCellRenderer.this._header;
            }

            @Override
            public String getAccessibleDescription() {
                return ItemTableCellRenderer.this._description.getText();
            }
        }
    }

    final class NoResultsFoundPanel
    extends JPanel
    implements ActionListener {
        final JLabel feedback;
        final JButton expandSearch;
        final GallerySearchListener expandSearchListener;

        NoResultsFoundPanel(GallerySearchListener searchListener) {
            this.expandSearchListener = searchListener;
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.weightx = 1.0;
            g.anchor = 17;
            g.insets.bottom = 10;
            this.feedback = new JLabel();
            ResourceUtils.resLabel((JLabel)this.feedback, null, (String)GalleryArb.getString((int)19));
            this.add((Component)this.feedback, g);
            ++g.gridy;
            if (this.expandSearchListener != null) {
                this.expandSearch = new JButton();
                ResourceUtils.resButton((AbstractButton)this.expandSearch, (String)GalleryArb.getString((int)20));
                this.add((Component)this.expandSearch, g);
                this.expandSearch.addActionListener(this);
            } else {
                this.expandSearch = null;
            }
            g.fill = 1;
            g.weighty = 1.0;
            ++g.gridy;
            this.add((Component)Box.createVerticalBox(), g);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.expandSearchListener != null) {
                GallerySearchEvent itemSearchEvent = new GallerySearchEvent(this, ObjectGalleryPanel.this.searchField.getText());
                this.expandSearchListener.searchExpanded(itemSearchEvent);
            }
        }
    }
}

