/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ide.wizard.spi.WizardHook;
import javax.ide.wizard.spi.WizardInfo;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.GallerySearchEvent;
import oracle.ide.gallery.GallerySearchListener;
import oracle.ide.gallery.GalleryXMLDataNode;
import oracle.ide.gallery.JavaxIdeElementInfo;
import oracle.ide.gallery.ObjectGalleryAddin;
import oracle.ide.gallery.ObjectGalleryPanel;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.gallery.TabbedObjectGalleryPanel;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.resource.GalleryArb;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public final class ObjectGallery {
    private static final String XML_FILENAME = "gallery.xml";
    private final SizeKeeperCallback _dialogCallback = new SizeKeeperCallback("new.gallery");
    private XMLDataNode _model;
    private Context _context;
    private JEWTFinishDialog _dlg;
    private GalleryElement _selItem;
    private TabbedObjectGalleryPanel _panel;
    private boolean _loadedHook = false;

    public ObjectGallery() {
        File xmlFile = new File(Ide.getLibDirectory(), XML_FILENAME);
        URL url = URLFactory.newFileURL((File)xmlFile);
        this._model = new GalleryXMLDataNode(url);
    }

    public GalleryFolder getModel() {
        return (GalleryFolder)this._model.getData();
    }

    public void runDialog(Context context) {
        this.runDialog(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDialog(Context context, String initialFolder, String initialSelection) {
        if (this._context != null) {
            return;
        }
        try {
            this._context = context;
            this.loadGalleryData();
            this._dlg = new JEWTFinishDialog((Frame)Ide.getMainWindow(), GalleryArb.getString((int)6), 7);
            RootGalleryFolder rootFolder = (RootGalleryFolder)this._model.getData();
            EventAdapter eventAdapter = new EventAdapter();
            if (context != null && context.getProject() != null) {
                ObjectGalleryPanel allItemsPanel = new ObjectGalleryPanel(rootFolder, context);
                ObjectGalleryPanel projectTechnologiesPanel = new ObjectGalleryPanel(rootFolder, context, true, eventAdapter);
                this._panel = new TabbedObjectGalleryPanel(allItemsPanel, projectTechnologiesPanel);
                this._panel.addChangeListener(eventAdapter);
            } else {
                boolean filtered = context == null || context.getProject() == null;
                ObjectGalleryPanel panel = new ObjectGalleryPanel(rootFolder, context, filtered);
                this._panel = new TabbedObjectGalleryPanel(panel);
            }
            this._panel.addListSelectionListener(eventAdapter);
            this._panel.addActionListener(eventAdapter);
            this._dlg.setOKButtonEnabled(false);
            this._dlg.setContent(this._panel);
            this._dlg.setResizable(true);
            this._panel.setContext(context);
            this._panel.setInitialSelection(initialFolder, initialSelection);
            this.activateTab(rootFolder.getLastSelectedTab());
            this._dlg.setPreferredSize(TDialogLauncher.getPreferredDefaultInitialSize());
            this._dlg.setInitialFocus(this._panel.getInitialFocusComponent());
            this.setCanAdvance();
            this._dialogCallback.dialogAboutToRun((JDialog)((Object)this._dlg));
            boolean finished = WizardLauncher.runDialog((JDialog)((Object)this._dlg));
            rootFolder.setMainDividerLocation(this._panel.getMainDividerLocation());
            if (this._panel.getTabCount() == 2) {
                rootFolder.setLastSelectedTab(this._panel.getSelectedIndex());
            }
            if (finished) {
                this.invokeWizard(this._selItem);
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
        }
        finally {
            this._context = null;
            this._dlg = null;
            this._selItem = null;
            this._panel = null;
        }
    }

    private void activateTab(int tabIndex) {
        if (this._panel.getTabCount() == 2) {
            if (!this.hasTechnologyScope(this._context)) {
                tabIndex = 0;
            } else if (tabIndex == -1) {
                tabIndex = 1;
            }
        }
        this._panel.setSelectedIndex(tabIndex);
    }

    private boolean hasTechnologyScope(Context context) {
        if (context == null || context.getProject() == null) {
            return false;
        }
        TechnologyScope techScope = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope();
        return techScope != null && !techScope.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGalleryData() {
        PrintStream log = this.getDebugOutputStream();
        if (!this._loadedHook) {
            try {
                ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                GalleryHandler galleryHook = (GalleryHandler)er.getHook(GalleryHandler.ELEMENT);
                GalleryManager mgr = GalleryManager.getGalleryManager();
                ((ObjectGalleryAddin)mgr).registerFolders(galleryHook.getFolders());
                Set items = galleryHook.getItems();
                if (log != null) {
                    log.println("Found " + items.size() + " Hook items");
                    log.println();
                }
                Iterator itemIterator = items.iterator();
                while (itemIterator.hasNext()) {
                    try {
                        ElementInfo item = (ElementInfo)itemIterator.next();
                        if (log != null && item.getPath().length == 2) {
                            String nameInfo;
                            String[] pathInfo = item.getPath();
                            String string = nameInfo = item.getName() == null ? item.getWizardClass() : item.getName();
                            if (nameInfo == null) {
                                nameInfo = "";
                            }
                            log.println("Registering: " + pathInfo[0] + ": " + pathInfo[1] + ": " + nameInfo);
                        }
                        mgr.registerGalleryElement(item);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                WizardHook wizHook = (WizardHook)ExtensionRegistry.getExtensionRegistry().getHook(WizardHook.ELEMENT);
                Collection classes = wizHook.getAllWizardClasses();
                Iterator classIterator = classes.iterator();
                while (classIterator.hasNext()) {
                    try {
                        WizardInfo wi = wizHook.getWizardInfo((String)classIterator.next());
                        mgr.registerGalleryElement(new JavaxIdeElementInfo(wi));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                this._loadedHook = true;
            }
        }
        try {
            this._model.open();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.flushPendingGalleryItems(log);
    }

    static final boolean isWizardAvailable(Wizard w, Context context) {
        if (w != null) {
            try {
                return w.isAvailable(context);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    private void invokeWizard(GalleryElement element) {
        if (this._selItem != null && this._selItem.getWizard() != null) {
            GalleryElement ge = element;
            Context ctx = this._context;
            Wizard wiz = ge.getWizard();
            if (wiz != null) {
                this.reportCreateDocument(ge);
                String[] wizParams = ge.getWizardParameters();
                String[] techKeys = ge.getTechnologyKeys();
                WizardManager.getInstance().invokeSecondaryWizard(wiz, ctx, wizParams, techKeys);
            }
        }
    }

    private void reportCreateDocument(GalleryElement galleryElement) {
        Wizard wiz = galleryElement.getWizard();
        String wizardClassName = galleryElement.getWizardClass() != null ? galleryElement.getWizardClass() : wiz.getClass().getName();
        UsagesTracker tracker = UsagesTracker.getUsagesTracker();
        UsageData data = tracker.createUsageData();
        data.setUsageType("CREATE_DOCUMENT");
        data.setExtensionId(wizardClassName);
        data.setPropertyId(galleryElement.getShortLabel());
        tracker.report(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCanAdvance() {
        if (this._dlg != null) {
            Wizard w;
            try {
                GalleryElement sel;
                this._selItem = sel = this._panel.getSelectedItem();
                w = this._selItem != null ? this._selItem.getWizard() : null;
            }
            catch (Exception ex) {
                Wizard w2;
                try {
                    this._selItem = null;
                    w2 = this._selItem != null ? this._selItem.getWizard() : null;
                }
                catch (Throwable throwable) {
                    Wizard w3 = this._selItem != null ? this._selItem.getWizard() : null;
                    this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(w3, this._context));
                    throw throwable;
                }
                this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(w2, this._context));
            }
            this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(w, this._context));
        }
    }

    private static ObjectGalleryAddin getObjectGalleryAddin() {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        if (galleryManager instanceof ObjectGalleryAddin) {
            return (ObjectGalleryAddin)galleryManager;
        }
        return null;
    }

    private void flushPendingGalleryItems(PrintStream log) {
        ObjectGalleryAddin galleryAddin = ObjectGallery.getObjectGalleryAddin();
        if (galleryAddin != null) {
            galleryAddin.removePendingGalleryItems(log);
            galleryAddin.addPendingGalleryItems(log);
        }
        this.printDebugInfo(log);
    }

    private void printDebugInfo(PrintStream log) {
        GalleryFolder f;
        if (log != null && (f = this.getModel()) != null) {
            TreeMap techMap = new TreeMap();
            Context context = this._context;
            if (context != null) {
                log.println();
                log.println("Context Info");
                log.println("--------------------");
                log.println("Project: " + (context.getProject() != null ? context.getProject().getShortLabel() : "<null>"));
                log.println("Element: " + (context.getElement() != null ? context.getElement().toString() : "<null>"));
                log.println("View: " + (context.getView() != null ? context.getView().getId() : "<null>"));
                log.println("Node: " + (context.getNode() != null ? context.getNode().getShortLabel() : "<null>"));
                log.println("Workspace: " + (context.getWorkspace() != null ? context.getWorkspace().getLongLabel() : "<null>"));
            }
            log.println();
            log.println("Technologies By Item");
            log.println("--------------------");
            f.debugLogTechnologies(log, null, techMap);
            log.println();
            log.println("Items By Technology");
            log.println("-------------------");
            for (Map.Entry entry : techMap.entrySet()) {
                String tech = (String)entry.getKey();
                log.println();
                log.println(tech + ":");
                List l = (List)entry.getValue();
                Iterator it2 = l.iterator();
                while (it2.hasNext()) {
                    log.println("  " + (String)it2.next());
                }
            }
        }
    }

    private PrintStream getDebugOutputStream() {
        PrintStream log = null;
        String property = System.getProperty("jdev.debug.technology.log");
        if (ModelUtil.hasLength((String)property)) {
            System.out.println();
            System.out.println("GALLERY DEBUGGING ENABLED (System property jdev.debug.technology.log=" + property + ")");
            if (Boolean.parseBoolean(property)) {
                log = System.out;
            } else if (property.equals("System.out")) {
                log = System.out;
            } else if (property.equals("System.err")) {
                log = System.err;
            } else {
                try {
                    log = new PrintStream(new FileOutputStream(property));
                }
                catch (FileNotFoundException ex) {
                    System.err.println("ERROR opening technology log: " + property + ". Logging to System.err instead.");
                    log = System.err;
                }
            }
        }
        return log;
    }

    private static final class JEWTFinishDialog
    extends JEWTDialog {
        private static final String DFT_SYMBOL = "new-gallery";

        public JEWTFinishDialog(Frame f, String s, int i) {
            super(f, s, i);
            this.setName(DFT_SYMBOL);
            this.setSize(600, 400);
        }

        public void finish() {
            this.dismissDialog(false);
        }
    }

    private final class EventAdapter
    implements ActionListener,
    ChangeListener,
    GallerySearchListener,
    ListSelectionListener {
        private EventAdapter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard w;
            if (ObjectGallery.this._selItem != null && ObjectGallery.isWizardAvailable(w = ObjectGallery.this._selItem.getWizard(), ObjectGallery.this._context)) {
                ObjectGallery.this._dlg.finish();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjectGallery.this.setCanAdvance();
            }
        }

        @Override
        public void searchExpanded(GallerySearchEvent event) {
            ((ObjectGalleryPanel)((ObjectGallery)ObjectGallery.this)._panel.getComponentAt((int)0)).searchField.setText(event.getSearchText());
            ObjectGallery.this._panel.setSelectedIndex(0);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ObjectGallery.this.setCanAdvance();
        }
    }
}

