/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.ArrayList;
import java.util.Collections;
import javax.ide.util.MissingIconException;
import javax.ide.wizard.spi.WizardCategory;
import javax.ide.wizard.spi.WizardInfo;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.JavaxIdeWizard;
import oracle.javatools.icons.OracleIcons;

final class JavaxIdeElementInfo
extends ElementInfo {
    private final WizardInfo _wizardInfo;

    JavaxIdeElementInfo(WizardInfo wi) {
        this._wizardInfo = wi;
    }

    @Override
    public String getName() {
        return this._wizardInfo.getLabel();
    }

    @Override
    public String getDescription() {
        return this._wizardInfo.getToolTip();
    }

    @Override
    public String[] getPath() {
        if (this._wizardInfo.getCategory() == WizardCategory.NONE) {
            return new String[]{"General"};
        }
        ArrayList<String> path = new ArrayList<String>();
        for (WizardCategory cat = this._wizardInfo.getCategory(); cat != WizardCategory.NONE; cat = cat.getParent()) {
            path.add(cat.getLabel());
        }
        Collections.reverse(path);
        return path.toArray(new String[path.size()]);
    }

    @Override
    public GalleryElement createElement() {
        GalleryElement element = new GalleryElement(new JavaxIdeWizard(this._wizardInfo));
        element.setWizardClass("oracle.ide.gallery.JavaxIdeWizard");
        element.setName(this.getName());
        element.setDescription(this.getDescription());
        Icon icon = null;
        if (this._wizardInfo.getIcon() != null) {
            try {
                icon = new ImageIcon(this._wizardInfo.getIcon().getURL());
            }
            catch (MissingIconException e) {
                e.printStackTrace();
            }
        }
        if (icon == null) {
            icon = OracleIcons.getIcon((String)"file.png");
        }
        element.setIcon(icon);
        element.setUnsorted(false);
        element.setWizardParameters(new String[0]);
        element.setTechnologyKeys(new String[0]);
        return element;
    }
}

