/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NStringVisitor;
import oracle.ide.IdeHook;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.javatools.util.Pair;

public class GalleryHandler
extends IdeHook {
    static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "gallery");
    private static final String FOLDER_ITEM_KEY = "folders_item_key";
    private static final String TRANSLATED_LABEL_ATTRIBUTE = "label";
    private static final String ITEM_KEY = "item_key";
    private static final String PARAMETER_KEY = "parameter_key";
    private static final String TECHNOLOGY_KEY = "technology_key";
    private static final String PATH_KEY = "category-folder_key";
    private final Set _items = new LinkedHashSet();
    private final Properties _generators = new Properties();
    private final Set _folders = new LinkedHashSet();
    private ElementVisitor _itemHandler = new ItemHandler();
    private ElementVisitor _generatorItemVisitor = new GeneratorItemVisitor();
    private ElementVisitor _galleryHandler = new GeneratorHandler();
    private ElementVisitor _foldersHandler = new FoldersHandler();
    private static final ElementName ITEM = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "item");
    private static final ElementName GENERATORS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "generators");
    private static final ElementName FOLDERS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "folders");
    private static final ElementName KEY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "key");
    private static final ElementName VALUE = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "value");
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "name");
    private static final ElementName UNSORTED = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "unsorted");
    private static final ElementName CATEGORY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "category");
    private static final ElementName RESCLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "resClass");
    private static final ElementName DESCRIPTION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "description");
    private static final ElementName HELP = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "help");
    private static final ElementName ICON = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "icon");
    private static final ElementName FOLDER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "folder");
    private static final ElementName PARAMETER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "parameter");
    private static final ElementName TECHNOLOGYKEY = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "technologyKey");

    Properties getGenerators() {
        return this._generators;
    }

    Set getItems() {
        return this._items;
    }

    Set getFolders() {
        return this._folders;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ITEM, this._itemHandler);
        context.registerChildVisitor(GENERATORS, this._galleryHandler);
        context.registerChildVisitor(FOLDERS, this._foldersHandler);
    }

    private abstract class NameValueVisitor
    extends ElementVisitor {
        private final ElementName _nameElement;
        private final ElementName _valueElement;
        private static final String PAIR = "pair";

        public NameValueVisitor(ElementName nameElement, ElementName valueElement) {
            this._nameElement = nameElement;
            this._valueElement = valueElement;
        }

        public void start(ElementStartContext context) {
            context.getScopeData().put(PAIR, new Pair());
            context.registerChildVisitor(this._nameElement, new ElementVisitor(){

                public void end(ElementEndContext context) {
                    Pair p = (Pair)context.getScopeData().get(NameValueVisitor.PAIR);
                    p.setFirst((Object)context.getText());
                }
            });
            context.registerChildVisitor(this._valueElement, new ElementVisitor(){

                public void end(ElementEndContext context) {
                    Pair p = (Pair)context.getScopeData().get(NameValueVisitor.PAIR);
                    p.setSecond((Object)context.getText());
                }
            });
        }

        public void end(ElementEndContext context) {
            Pair p = (Pair)context.getScopeData().get(PAIR);
            this.nameValue((ElementContext)context, (String)p.getFirst(), (String)p.getSecond());
        }

        protected abstract void nameValue(ElementContext var1, String var2, String var3);
    }

    private final class ItemHandler
    extends ElementVisitor {
        private ElementVisitor _nameHandler = new NameHandler();
        private ElementVisitor _resClassHandler = new ResClassHandler();
        private ElementVisitor _descriptionHandler = new DescriptionHandler();
        private ElementVisitor _helpHandler = new HelpHandler();
        private ElementVisitor _iconHandler = new IconHandler();
        private ElementVisitor _unsortedHandler = new UnsortedHandler();
        private ElementVisitor _categoryHandler = new CategoryHandler();
        private ElementVisitor _folderHandler = new FolderHandler();
        private ElementVisitor _parameterHandler = new ParameterHandler();
        private ElementVisitor _technologyHandler = new TechnologyKeyHandler();

        private ItemHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(NAME, this._nameHandler);
            context.registerChildVisitor(RESCLASS, this._resClassHandler);
            context.registerChildVisitor(DESCRIPTION, this._descriptionHandler);
            context.registerChildVisitor(HELP, this._helpHandler);
            context.registerChildVisitor(ICON, this._iconHandler);
            context.registerChildVisitor(UNSORTED, this._unsortedHandler);
            context.registerChildVisitor(CATEGORY, this._categoryHandler);
            context.registerChildVisitor(FOLDER, this._folderHandler);
            context.registerChildVisitor(PARAMETER, this._parameterHandler);
            context.registerChildVisitor(TECHNOLOGYKEY, this._technologyHandler);
            context.getScopeData().put(GalleryHandler.ITEM_KEY, new ElementInfo());
            context.getScopeData().put(GalleryHandler.PARAMETER_KEY, new ArrayList());
            context.getScopeData().put(GalleryHandler.TECHNOLOGY_KEY, new ArrayList());
            context.getScopeData().put(GalleryHandler.PATH_KEY, new Pair());
        }

        public void end(ElementEndContext context) {
            List parameters = (List)context.getScopeData().get(GalleryHandler.PARAMETER_KEY);
            List technology = (List)context.getScopeData().get(GalleryHandler.TECHNOLOGY_KEY);
            Pair path = (Pair)context.getScopeData().get(GalleryHandler.PATH_KEY);
            this.getItem((ElementContext)context).setWizardParameters(this.convertToArray(parameters));
            this.getItem((ElementContext)context).setTechnologyKeys(this.convertToArray(technology));
            if (path.getFirst() == null) {
                this.getItem((ElementContext)context).setPath((String)path.getSecond());
            } else {
                this.getItem((ElementContext)context).setPath((String)path.getFirst(), (String)path.getSecond());
            }
            GalleryHandler.this._items.add(this.getItem((ElementContext)context));
        }

        private ElementInfo getItem(ElementContext context) {
            return (ElementInfo)context.getScopeData().get(GalleryHandler.ITEM_KEY);
        }

        private String[] convertToArray(List l) {
            return l != null ? l.toArray(new String[l.size()]) : null;
        }

        public class TechnologyKeyHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                List technology = (List)context.getScopeData().get(GalleryHandler.TECHNOLOGY_KEY);
                String text = context.getText();
                text = text == null ? null : text.trim();
                technology.add(text);
            }
        }

        public class ParameterHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                List parameters = (List)context.getScopeData().get(GalleryHandler.PARAMETER_KEY);
                parameters.add(context.getText().trim());
            }
        }

        public class FolderHandler
        extends I18NStringVisitor {
            public void string(ElementContext context, String value) {
                Pair path = (Pair)context.getScopeData().get(GalleryHandler.PATH_KEY);
                path.setSecond((Object)value);
            }
        }

        public class CategoryHandler
        extends I18NStringVisitor {
            protected void string(ElementContext context, String value) {
                Pair path = (Pair)context.getScopeData().get(GalleryHandler.PATH_KEY);
                path.setFirst((Object)value);
            }
        }

        public class UnsortedHandler
        extends BooleanVisitor {
            protected void booleanValue(ElementContext context, boolean value) {
                ItemHandler.this.getItem(context).setUnsorted(value);
            }
        }

        public class IconHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                ItemHandler.this.getItem((ElementContext)context).setIconFile(context.getText().trim());
            }
        }

        public class HelpHandler
        extends I18NStringVisitor {
            public void string(ElementContext context, String value) {
                ItemHandler.this.getItem(context).setDescription(value);
            }
        }

        public class DescriptionHandler
        extends I18NStringVisitor {
            protected void string(ElementContext context, String value) {
                ItemHandler.this.getItem(context).setName(value);
            }
        }

        public class ResClassHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                ItemHandler.this.getItem((ElementContext)context).setResClass(context.getText().trim());
            }
        }

        public class NameHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
                ElementInfo info = ItemHandler.this.getItem((ElementContext)context);
                info.setWizardClass(context.getText().trim());
                info.setWizardClassLoader(loader);
            }
        }
    }

    private final class FoldersHandler
    extends ElementVisitor {
        private ElementVisitor _nameHandler = new FolderNameHandler();
        private ElementVisitor _unsortedHandler = new UnsortedHandler();
        private ElementVisitor _categoryHandler = new CategoryHandler();

        private FoldersHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(NAME, this._nameHandler);
            context.registerChildVisitor(UNSORTED, this._unsortedHandler);
            context.registerChildVisitor(CATEGORY, this._categoryHandler);
            context.getScopeData().put(GalleryHandler.FOLDER_ITEM_KEY, new FolderInfo());
        }

        public void end(ElementEndContext context) {
            GalleryHandler.this._folders.add(this.getFolder((ElementContext)context));
        }

        private FolderInfo getFolder(ElementContext context) {
            return (FolderInfo)context.getScopeData().get(GalleryHandler.FOLDER_ITEM_KEY);
        }

        private class CategoryHandler
        extends I18NStringVisitor {
            private CategoryHandler() {
            }

            public void string(ElementContext context, String value) {
                FoldersHandler.this.getFolder(context).setCategory(value);
            }
        }

        private final class UnsortedHandler
        extends BooleanVisitor {
            private UnsortedHandler() {
            }

            public void booleanValue(ElementContext context, boolean value) {
                FoldersHandler.this.getFolder(context).setUnsorted(value);
            }
        }

        private final class FolderNameHandler
        extends I18NStringVisitor {
            private FolderNameHandler() {
            }

            public void start(ElementStartContext start) {
                super.start(start);
                String attributeValue = start.getAttributeValue(GalleryHandler.TRANSLATED_LABEL_ATTRIBUTE);
                FoldersHandler.this.getFolder((ElementContext)start).setLabel(attributeValue);
            }

            protected void string(ElementContext context, String value) {
                FoldersHandler.this.getFolder(context).setName(value);
            }
        }
    }

    private final class GeneratorHandler
    extends ElementVisitor {
        private GeneratorHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(ITEM, GalleryHandler.this._generatorItemVisitor);
        }
    }

    private final class GeneratorItemVisitor
    extends NameValueVisitor {
        GeneratorItemVisitor() {
            super(KEY, VALUE);
        }

        @Override
        protected void nameValue(ElementContext context, String name, String value) {
            GalleryHandler.this._generators.put(name, value);
        }
    }
}

