/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.Arrays;
import oracle.ide.ExtensionRegistry;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.wizard.Wizard;

public class ElementInfo {
    private String[] _path;
    private Wizard _wzClass;
    private String _clazz;
    private ClassLoader _classLoader;
    private String[] _params;
    private String _name;
    private String _description;
    private String _iconFile;
    private boolean _unsorted;
    private String[] _technologyKeys;
    private String _resClass;

    public ElementInfo(String[] path, String clazz, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this.pathMustHaveNoNullElements(path);
        this._path = path;
        this._clazz = clazz;
        this._name = name;
        this._description = description;
        this._iconFile = iconFile;
        this._unsorted = unsorted;
        this._params = params;
    }

    public ElementInfo(String[] path, Wizard wzClass, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this.pathMustHaveNoNullElements(path);
        this._path = path;
        this._wzClass = wzClass;
        this._name = name;
        this._description = description;
        this._iconFile = iconFile;
        this._unsorted = unsorted;
        this._params = params;
    }

    private void pathMustHaveNoNullElements(Object[] path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        for (int i = 0; i < path.length; ++i) {
            if (path[i] != null) continue;
            throw new NullPointerException("path element " + i + " is null");
        }
    }

    public ElementInfo(String categoryName, String folderName, String clazz, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this(ElementInfo.makePath(categoryName, folderName), clazz, params, name, description, iconFile, unsorted);
    }

    public ElementInfo(String categoryName, String folderName, Wizard clazz, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this(ElementInfo.makePath(categoryName, folderName), clazz, params, name, description, iconFile, unsorted);
    }

    public ElementInfo() {
    }

    ElementInfo(String folderName, String clazz, String[] params, String name) {
        this(ElementInfo.makePath(null, folderName), clazz, params, name, null, null, false);
    }

    ElementInfo(String categoryName, String folderName, String clazz, String[] params, String name) {
        this(ElementInfo.makePath(categoryName, folderName), clazz, params, name, null, null, false);
    }

    ElementInfo(String categoryName, String folderName, String clazz, String[] params, String name, String description) {
        this(ElementInfo.makePath(categoryName, folderName), clazz, params, name, description, null, false);
    }

    public String[] getPath() {
        return this._path;
    }

    public void setPath(String[] path) {
        this._path = path;
    }

    public void setPath(String folderName) {
        this._path = ElementInfo.makePath(null, folderName);
    }

    public void setPath(String categoryName, String folderName) {
        this._path = ElementInfo.makePath(categoryName, folderName);
    }

    public String getWizardClass() {
        return this._clazz;
    }

    public ClassLoader getWizardClassLoader() {
        if (this._classLoader == null) {
            return ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.ide");
        }
        return this._classLoader;
    }

    public void setWizardClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    public void setWizardClass(String clazz) {
        this._clazz = clazz;
    }

    public Wizard getWizard() {
        return this._wzClass;
    }

    public void setWizard(Wizard wizard) {
        this._wzClass = wizard;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getIconFile() {
        return this._iconFile;
    }

    public void setIconFile(String iconFile) {
        this._iconFile = iconFile;
    }

    public String[] getWizardParameters() {
        return this._params;
    }

    public void setWizardParameters(String[] params) {
        this._params = params;
    }

    public boolean getUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this._unsorted = unsorted;
    }

    public String[] getTechnologyKeys() {
        return this._technologyKeys;
    }

    public void setTechnologyKeys(String[] technologyKeys) {
        this._technologyKeys = technologyKeys;
    }

    public String getResClass() {
        return this._resClass;
    }

    public void setResClass(String resClass) {
        this._resClass = resClass;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementInfo)) {
            return false;
        }
        return this.equalsImpl((ElementInfo)obj);
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + Arrays.hashCode(this._path);
        result = 37 * result + (this._wzClass == null ? 0 : this._wzClass.hashCode());
        result = 37 * result + (this._clazz == null ? 0 : this._clazz.hashCode());
        result = 37 * result + Arrays.hashCode(this._params);
        result = 37 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 37 * result + (this._description == null ? 0 : this._description.hashCode());
        result = 37 * result + (this._iconFile == null ? 0 : this._iconFile.hashCode());
        result = 37 * result + (this._unsorted ? 0 : 1);
        result = 37 * result + Arrays.hashCode(this._technologyKeys);
        result = 37 * result + (this._resClass == null ? 0 : this._resClass.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("path = ").append(Arrays.toString(this._path));
        b.append("; name = ").append(this._name);
        b.append("; description = ").append(this._description);
        b.append("; wizard class = ").append(this._wzClass);
        b.append("; wizard class loader = ").append(this._classLoader);
        b.append("; class = ").append(this._clazz);
        b.append("; params = ").append(Arrays.toString(this._params));
        b.append("; icon file = ").append(this._iconFile);
        b.append("; unsorted = ").append(this._unsorted);
        b.append("; icon file = ").append(this._iconFile);
        b.append("; resource key = ").append(this._resClass);
        b.append("; technologies = ").append(Arrays.toString(this._technologyKeys));
        return b.toString();
    }

    public GalleryElement createElement() {
        GalleryElement ele = new GalleryElement(this.getWizard());
        ele.setWizardClassLoader(this.getWizardClassLoader());
        ele.setWizardClass(this.getWizardClass());
        ele.setName(this.getName());
        ele.setDescription(this.getDescription());
        ele.setIconFile(this.getIconFile());
        ele.setUnsorted(this.getUnsorted());
        ele.setWizardParameters(this.getWizardParameters());
        ele.setTechnologyKeys(this.getTechnologyKeys());
        ele.setResClass(this.getResClass());
        return ele;
    }

    private boolean equalsImpl(ElementInfo info) {
        if (!Arrays.equals(this._path, info._path)) {
            return false;
        }
        if (!(this._clazz != null ? this._clazz.equals(info._clazz) : info._clazz == null)) {
            return false;
        }
        if (!(this._wzClass != null ? this._wzClass.equals(info._wzClass) : info._wzClass == null)) {
            return false;
        }
        if (!(this._name != null ? this._name.equals(info._name) : info._name == null)) {
            return false;
        }
        if (!(this._description != null ? this._description.equals(info._description) : info._description == null)) {
            return false;
        }
        if (!(this._iconFile != null ? this._iconFile.equals(info._iconFile) : info._iconFile == null)) {
            return false;
        }
        if (this._unsorted != info._unsorted) {
            return false;
        }
        if (!Arrays.equals(this._params, info._params)) {
            return false;
        }
        if (!Arrays.equals(this._technologyKeys, info._technologyKeys)) {
            return false;
        }
        return this._resClass != null ? this._resClass.equals(info._resClass) : info._resClass == null;
    }

    static String[] makePath(String categoryName, String folderName) {
        String[] stringArray;
        if (folderName == null) {
            throw new NullPointerException("folderName must not be null.");
        }
        if (categoryName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = folderName;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = categoryName;
            stringArray = stringArray3;
            stringArray3[1] = folderName;
        }
        return stringArray;
    }
}

