/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.view;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.controller.Command;

public class UndoableEditCommand
extends Command {
    private static final int CMD_ID = Ide.findOrCreateCmdID((String)UndoableEditCommand.class.getName());
    private UndoableEdit _undoableEdit;

    public UndoableEditCommand(UndoableEdit undoableEdit) {
        super(CMD_ID, 0);
        this._undoableEdit = undoableEdit;
    }

    public UndoableEdit getUndoableEdit() {
        return this._undoableEdit;
    }

    public int doit() throws Exception {
        try {
            if (this._undoableEdit.canRedo()) {
                this._undoableEdit.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
        return 0;
    }

    public int undo() throws Exception {
        try {
            if (this._undoableEdit.canUndo()) {
                this._undoableEdit.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
        return 0;
    }

    public String getName() {
        return this._undoableEdit.getPresentationName();
    }
}

