/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.diffmerge.DiffMergeActions;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeURLHelper;
import oracle.ide.diffmerge.view.ResourceDirectoryNode;
import oracle.ide.diffmerge.view.ResourceNode;
import oracle.ide.diffmerge.view.ResourceTextNode;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.javatools.compare.CompareType;

public class DiffMergeNode
extends Node {
    private boolean _saved;
    private final DiffMergeArguments _arguments;
    private final Node[] _nodes;
    private final NodeListener _nodeListener = new NodeListener(){

        public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
            boolean dirty = false;
            if (DiffMergeNode.this._nodes != null) {
                for (Node node : DiffMergeNode.this._nodes) {
                    dirty = dirty || node.isDirty();
                }
            }
            DiffMergeNode.this.markDirty(dirty);
        }
    };

    public DiffMergeNode(DiffMergeArguments arguments) {
        this._arguments = arguments;
        this._nodes = DiffMergeNode.createNodes(arguments);
        this.setURL(DiffMergeURLHelper.newDiffMergeURL(arguments));
        this.getAttributes().set(ElementAttributes.CLOSEABLE | ElementAttributes.SAVEABLE);
    }

    public void open(Context context) throws IOException {
        if (!this.isOpen()) {
            this.open();
            EditorUtil.openExplicitEditorInFrame((Class)EditorManager.getEditorManager().getDefaultAddin((Element)this).getEditorClass(), (Context)context);
        }
    }

    protected void openImpl() throws IOException {
        this.attachNodes();
        for (int i = 0; this._nodes != null && i < this._nodes.length; ++i) {
            this._nodes[i].open();
        }
    }

    protected void closeImpl() throws IOException {
        for (int i = 0; this._nodes != null && i < this._nodes.length; ++i) {
            this._nodes[i].close();
        }
        this.detachNodes();
        NodeFactory.uncache((URL)this.getURL());
    }

    protected void saveImpl() throws IOException {
        DiffMergeArguments arguments = this.getArguments();
        if (!arguments.isMergeTask()) {
            for (int i = 0; this._nodes != null && i < this._nodes.length; ++i) {
                this._nodes[i].save();
            }
            return;
        }
        if (!this.isOpen() || !this.isDirty()) {
            return;
        }
        ResourceNode ancestorNode = this.getAncestorNode();
        if (ancestorNode.isOpen() && ancestorNode.isDirty()) {
            ancestorNode.save(arguments.getOutput());
        }
    }

    public Icon getIcon() {
        IdeAction ideAction = DiffMergeActions.getDiffMergeAction();
        return (Icon)ideAction.getValue("SmallIcon");
    }

    public ResourceNode getSourceNode() {
        return this.getNodes() != null ? (ResourceNode)this.getNodes()[0] : null;
    }

    public ResourceNode getTargetNode() {
        return this.getNodes() != null ? (ResourceNode)this.getNodes()[1] : null;
    }

    public ResourceNode getAncestorNode() {
        return this.getNodes() != null && this.getNodes().length > 2 ? (ResourceNode)this.getNodes()[2] : null;
    }

    public void setSaved(boolean saved) {
        this._saved = saved;
    }

    public boolean isSaved() {
        return this._saved;
    }

    public DiffMergeArguments getArguments() {
        return this._arguments;
    }

    public Node[] getNodes() {
        return this._nodes;
    }

    public void attachNodes() {
        for (int i = 0; this._nodes != null && i < this._nodes.length; ++i) {
            this._nodes[i].addNodeListener(this._nodeListener);
        }
    }

    public void detachNodes() {
        for (int i = 0; this._nodes != null && i < this._nodes.length; ++i) {
            this._nodes[i].removeNodeListener(this._nodeListener);
        }
    }

    private static final Node[] createNodes(DiffMergeArguments arguments) {
        if (arguments == null) {
            return null;
        }
        if (arguments.getSource() == null || arguments.getTarget() == null) {
            throw new IllegalArgumentException();
        }
        if (arguments.getCompareType() == CompareType.TEXT) {
            return DiffMergeNode.createTextNodes(arguments);
        }
        if (arguments.getCompareType() == CompareType.DIRECTORY) {
            return DiffMergeNode.createDirectoryNodes(arguments);
        }
        throw new IllegalArgumentException();
    }

    private static final Node[] createTextNodes(DiffMergeArguments arguments) {
        if (!arguments.isMergeTask() && arguments.getAncestor() == null) {
            return new Node[]{new ResourceTextNode(arguments.getSource()), new ResourceTextNode(arguments.getTarget())};
        }
        if (arguments.getAncestor() == null) {
            throw new IllegalArgumentException();
        }
        return new Node[]{new ResourceTextNode(arguments.getSource()), new ResourceTextNode(arguments.getTarget()), new ResourceTextNode(arguments.getAncestor())};
    }

    private static final Node[] createDirectoryNodes(DiffMergeArguments arguments) {
        if (!arguments.isMergeTask() && arguments.getAncestor() == null) {
            return new Node[]{new ResourceDirectoryNode(arguments.getSource()), new ResourceDirectoryNode(arguments.getTarget())};
        }
        if (arguments.getAncestor() == null) {
            throw new IllegalArgumentException();
        }
        return new Node[]{new ResourceDirectoryNode(arguments.getSource()), new ResourceDirectoryNode(arguments.getTarget()), new ResourceDirectoryNode(arguments.getAncestor())};
    }
}

