/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.diffmerge.DiffMergeActions;
import oracle.ide.diffmerge.DiffMergeController;
import oracle.ide.diffmerge.DiffMergeEditor;
import oracle.ide.diffmerge.DiffMergeNode;
import oracle.ide.diffmerge.DiffMergeURLHelper;
import oracle.ide.diffmerge.cmd.DiffMergeCloseNodeCommand;
import oracle.ide.diffmerge.cmd.DiffMergeExitCommand;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.MenuSpec;

public class DiffMergeAddin
extends EditorAddin {
    private MenuSpec _menuSpec;

    public void initialize() {
        if (!Ide.getProductID().equals("oracle.ide.diffmergevhv")) {
            return;
        }
        DiffMergeController.getInstance();
        EditorManager.getEditorManager().register((EditorAddin)this, new Class[]{DiffMergeNode.class});
        URLFileSystem.registerHelper((String)"ide.diffmerge", (URLFileSystemHelper)new DiffMergeURLHelper());
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        String closeNodeCommand = closeNodeAction.getCommand();
        closeNodeAction.setCommand("oracle.ide.diffmerge.cmd.DiffMergeCloseNodeCommand");
        DiffMergeCloseNodeCommand.setDelegateCommand(closeNodeCommand);
        IdeAction exitAction = IdeActions.getFileExitAction();
        String exitCommand = exitAction.getCommand();
        exitAction.setCommand("oracle.ide.diffmerge.cmd.DiffMergeExitCommand");
        DiffMergeExitCommand.setDelegateCommand(exitCommand);
    }

    public Class getEditorClass() {
        return DiffMergeEditor.class;
    }

    public boolean isDefault() {
        return false;
    }

    public MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            IdeAction ideAction = DiffMergeActions.getDiffMergeAction();
            this._menuSpec = new MenuSpec((String)ideAction.getValue("Name"), (Integer)ideAction.getValue("MnemonicKey"), (Icon)ideAction.getValue("SmallIcon"));
        }
        return this._menuSpec;
    }

    public float getEditorWeight(Element element) {
        return element instanceof DiffMergeNode ? -1.0f : Float.NaN;
    }

    public boolean isDuplicable() {
        return false;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    public void closeEditors() {
        ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!this.getEditorClass().isInstance(editor)) continue;
            editorsToClose.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(editorsToClose);
    }
}

