/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.boot;

import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;

public final class MigratorStarter
extends IdeStarter {
    private static final String USAGE = "Migrates project indexes.\n\nUsage\n    ojmigrate file...\n\nParameters\n    file                 Workspace or project to migrate.\n\nNotes\n    Ojmigrate migrates the indexes of workspaces or projects.\n\nExamples\n    ojmigrate application.jws\n      Migrate the indexes for the entire workspace application.jws.\n    ojmigrate project1.jpr project2.jpr\n      Migrate the indexes for projects project1.jpr and project2.jpr.\n    ojmigrate application.jws project.jpr\n      MIgrate the indexes for application.jws and project.jpr.\n";
    private String[] arguments;

    public void startIde(String command, String[] arguments, IdeCore core) {
        this.arguments = arguments;
        System.setProperty("display.logger.mode", "headless");
        if (arguments.length == 0 || arguments.length == 1 && "-help".equals(arguments[0])) {
            MigratorStarter.printUsage();
            System.exit(0);
        }
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        core.useInvokeLaterForAddinsLoadedEvenThoughHeadless();
        Ide.startup((IdeCore)core);
    }

    public String[] getArguments() {
        return this.arguments;
    }

    private static final void printUsage() {
        System.out.println(USAGE);
    }
}

