/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CIntervaldsAccessor
extends IntervaldsAccessor {
    T4CMAREngine mare;
    static int maxLength = 11;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    T4CIntervaldsAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, maxLength, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CIntervaldsAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, maxLength, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n4 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        this.mare.unmarshalCLR(this.rowSpaceByte, n4, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
        } else {
            this.rowSpaceIndicator[n3] = (short)this.meta[0];
            this.rowSpaceIndicator[n2] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n4 = this.columnIndex + n2 * this.byteLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2;
        short s2 = this.rowSpaceIndicator[n8];
        int n9 = this.metaDataIndex + this.lastRowProcessed * 1;
        int n10 = this.metaDataIndex + n2 * 1;
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, n4, this.rowSpaceByte, n3, s2);
        }
        System.arraycopy(this.rowSpaceMetaData, n10, this.rowSpaceMetaData, n9, 1);
        ++this.lastRowProcessed;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.byteLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.byteLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(byArray, n5, this.rowSpaceByte, n4, s2);
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n2);
                }
                case -104: {
                    return this.getINTERVALDS(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return var2_2;
    }
}

