/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILobd;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.sql.Datum;

abstract class T4C8TTILob
extends T4CTTIfun {
    static final int KPLOB_READ = 2;
    static final int KPLOB_WRITE = 64;
    static final int KPLOB_WRITE_APPEND = 8192;
    static final int KPLOB_PAGE_SIZE = 16384;
    static final int KPLOB_FILE_OPEN = 256;
    static final int KPLOB_FILE_ISOPEN = 1024;
    static final int KPLOB_FILE_EXISTS = 2048;
    static final int KPLOB_FILE_CLOSE = 512;
    static final int KPLOB_OPEN = 32768;
    static final int KPLOB_CLOSE = 65536;
    static final int KPLOB_ISOPEN = 69632;
    static final int KPLOB_TMP_CREATE = 272;
    static final int KPLOB_TMP_FREE = 273;
    static final int KPLOB_GET_LEN = 1;
    static final int KPLOB_TRIM = 32;
    static final int KOKL_ORDONLY = 1;
    static final int KOKL_ORDWR = 2;
    static final int KOLF_ORDONLY = 11;
    static final int DTYCLOB = 112;
    static final int DTYBLOB = 113;
    byte[] sourceLobLocator = null;
    byte[] destinationLobLocator = null;
    long sourceOffset = 0L;
    long destinationOffset = 0L;
    int destinationLength = 0;
    short characterSet = 0;
    long lobamt = 0L;
    boolean lobnull = false;
    long lobops = 0L;
    int[] lobscn = null;
    int lobscnl = 0;
    boolean nullO2U = false;
    boolean sendLobamt = false;
    byte[] inBuffer = null;
    long inBufferOffset;
    long inBufferNumBytes;
    byte[] outBuffer = null;
    int offsetInOutBuffer = 0;
    int rowsProcessed = 0;
    long lobBytesRead = 0L;
    boolean littleEndianClob = false;
    T4C8TTILobd lobd = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    T4C8TTILob(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)96);
        this.lobd = new T4C8TTILobd(t4CConnection);
    }

    long read(byte[] byArray, long l2, long l3, byte[] byArray2, int n2) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l3;
        this.sendLobamt = true;
        this.outBuffer = byArray2;
        this.offsetInOutBuffer = n2;
        this.doRPC();
        return this.lobBytesRead;
    }

    long write(byte[] byArray, long l2, byte[] byArray2, long l3, long l4) throws SQLException, IOException {
        long l5 = 0L;
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l4;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.inBufferOffset = l3;
        this.inBufferNumBytes = l4;
        this.doRPC();
        l5 = this.lobamt;
        return l5;
    }

    long getLength(byte[] byArray) throws SQLException, IOException {
        long l2 = 0L;
        this.initializeLobdef();
        this.lobops = 1L;
        this.sourceLobLocator = byArray;
        this.sendLobamt = true;
        this.doRPC();
        l2 = this.lobamt;
        return l2;
    }

    long getChunkSize(byte[] byArray) throws SQLException, IOException {
        long l2 = 0L;
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = byArray;
        this.sendLobamt = true;
        this.doRPC();
        l2 = this.lobamt;
        return l2;
    }

    long trim(byte[] byArray, long l2) throws SQLException, IOException {
        long l3 = 0L;
        this.initializeLobdef();
        this.lobops = 32L;
        this.sourceLobLocator = byArray;
        this.lobamt = l2;
        this.sendLobamt = true;
        this.doRPC();
        l3 = this.lobamt;
        return l3;
    }

    abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    void freeTemporaryLob(byte[] byArray) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 273L;
        this.sourceLobLocator = byArray;
        this.doRPC();
    }

    abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    boolean _open(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = false;
        if ((byArray[7] & 1) == 1 || (byArray[4] & 0x40) == 64) {
            if ((byArray[7] & 8) == 8) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 445);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray[7] = (byte)(byArray[7] | 8);
            if (n2 == 2) {
                byArray[7] = (byte)(byArray[7] | 0x10);
            }
            bl = true;
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n3;
            this.lobamt = n2;
            this.sendLobamt = true;
            this.doRPC();
            if (this.lobamt != 0L) {
                bl = true;
            }
        }
        return bl;
    }

    abstract boolean close(byte[] var1) throws SQLException, IOException;

    boolean _close(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = true;
        if ((byArray[7] & 1) == 1 || (byArray[4] & 0x40) == 64) {
            if ((byArray[7] & 8) != 8) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 446);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray[7] = (byte)(byArray[7] & 0xFFFFFFE7);
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n2;
            this.doRPC();
        }
        return bl;
    }

    abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    boolean _isOpen(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = false;
        if ((byArray[7] & 1) == 1 || (byArray[4] & 0x40) == 64) {
            if ((byArray[7] & 8) == 8) {
                bl = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n2;
            this.nullO2U = true;
            this.doRPC();
            bl = this.lobnull;
        }
        return bl;
    }

    void initializeLobdef() {
        this.sourceLobLocator = null;
        this.destinationLobLocator = null;
        this.sourceOffset = 0L;
        this.destinationOffset = 0L;
        this.destinationLength = 0;
        this.characterSet = 0;
        this.lobamt = 0L;
        this.lobnull = false;
        this.lobops = 0L;
        this.lobscn = null;
        this.lobscnl = 0;
        this.inBuffer = null;
        this.outBuffer = null;
        this.nullO2U = false;
        this.sendLobamt = false;
        this.littleEndianClob = false;
        this.lobBytesRead = 0L;
    }

    @Override
    void marshal() throws IOException {
        int n2 = 0;
        if (this.sourceLobLocator != null) {
            n2 = this.sourceLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(n2);
        if (this.destinationLobLocator != null) {
            this.destinationLength = this.destinationLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.destinationLength);
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.sourceOffset);
        }
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.destinationOffset);
        }
        if (this.characterSet != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.nullO2U) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.lobops);
        if (this.lobscnl != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.lobscnl);
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalSB8(this.sourceOffset);
            this.meg.marshalSB8(this.destinationOffset);
            if (this.sendLobamt) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            if (this.connection.getTTCVersion() >= 4) {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
        if (this.sourceLobLocator != null) {
            this.meg.marshalB1Array(this.sourceLobLocator);
        }
        if (this.destinationLobLocator != null) {
            this.meg.marshalB1Array(this.destinationLobLocator);
        }
        if (this.characterSet != 0) {
            this.meg.marshalUB2(this.characterSet);
        }
        if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
            this.meg.marshalUB4(this.lobamt);
        }
        if (this.lobscnl != 0) {
            for (int i2 = 0; i2 < this.lobscnl; ++i2) {
                this.meg.marshalUB4(this.lobscn[i2]);
            }
        }
        if (this.sendLobamt && this.connection.getTTCVersion() >= 3) {
            this.meg.marshalSB8(this.lobamt);
        }
        if (this.lobops == 64L) {
            this.marshalData();
        }
    }

    void marshalData() throws IOException {
        boolean bl = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
        boolean bl2 = false;
        if ((this.sourceLobLocator[6] & 0x80) == 128) {
            bl2 = true;
        }
        if (this.connection.versionNumber < 10101 && bl2) {
            this.lobd.marshalClobUB2_For9iDB(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes);
        } else {
            this.lobd.marshalLobData(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes, bl);
        }
    }

    @Override
    void readLOBD() throws IOException, SQLException {
        boolean bl = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
        boolean bl2 = false;
        if ((this.sourceLobLocator[6] & 0x80) == 128) {
            bl2 = true;
        }
        this.lobBytesRead = this.connection.versionNumber < 10101 && bl2 ? this.lobd.unmarshalClobUB2_For9iDB(this.outBuffer, this.offsetInOutBuffer) : this.lobd.unmarshalLobData(this.outBuffer, this.offsetInOutBuffer, bl);
    }

    @Override
    void processError() throws SQLException {
        this.rowsProcessed = this.oer.getCurRowNumber();
        if (this.oer.getRetCode() != 1403) {
            this.oer.processError();
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int n2;
        if (this.sourceLobLocator != null) {
            n2 = this.sourceLobLocator.length;
            this.meg.getNBytes(this.sourceLobLocator, 0, n2);
        }
        if (this.destinationLobLocator != null) {
            n2 = this.meg.unmarshalSB2();
            this.destinationLobLocator = this.meg.unmarshalNBytes(n2);
        }
        if (this.characterSet != 0) {
            this.characterSet = this.meg.unmarshalSB2();
        }
        if (this.sendLobamt) {
            this.lobamt = this.connection.getTTCVersion() >= 3 ? this.meg.unmarshalSB8() : this.meg.unmarshalUB4();
        }
        if (this.nullO2U && (n2 = (int)this.meg.unmarshalSB1()) != 0) {
            this.lobnull = true;
        }
    }
}

