/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ArrayDataResultSet
extends BaseResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    PhysicalConnection connection;
    private Boolean wasNull;
    private int fetchSize;
    ARRAY array;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:38:25_PDT_2012";
    public static final boolean TRACE = false;

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(n3 - this.currentIndex, n2);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.array = aRRAY;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.array == null ? 0 : aRRAY.length();
        this.lastIndex = this.currentIndex + (n2 == -1 ? n3 - this.currentIndex : Math.min(n3 - this.currentIndex, n2));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        ++this.currentIndex;
        return this.currentIndex <= this.lastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.wasNull == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.wasNull;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.stringValue();
            }
            return null;
        }
    }

    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        if (this.currentIndex <= 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, null);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 == 1) {
            this.wasNull = Boolean.FALSE;
            return new NUMBER(this.currentIndex);
        }
        if (n2 == 2) {
            Datum[] datumArray;
            if (this.data != null) {
                this.wasNull = this.data[this.currentIndex - 1] == null ? Boolean.TRUE : Boolean.FALSE;
                return this.data[this.currentIndex - 1];
            }
            if (this.array != null && (datumArray = this.array.getOracleArray(this.currentIndex, 1)) != null && datumArray.length >= 1) {
                this.wasNull = datumArray[0] == null ? Boolean.TRUE : Boolean.FALSE;
                return datumArray[0];
            }
            datumArray = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync");
            datumArray.fillInStackTrace();
            throw datumArray;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, null);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    return (ROWID)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    return (NUMBER)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof DATE) {
                    return (DATE)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    return (ARRAY)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return (STRUCT)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    return (OPAQUE)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof REF) {
                    return (REF)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    return (CHAR)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return (RAW)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    return (BLOB)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    return (CLOB)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    return (BFILE)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    return (INTERVALDS)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    return (INTERVALYM)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    return (TIMESTAMP)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    return (TIMESTAMPTZ)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    return (TIMESTAMPLTZ)datum;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.booleanValue();
            }
            return false;
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.byteValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2 = this.getLong(n2);
            if (l2 > 65537L || l2 < -65538L) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return (short)l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.intValue();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.longValue();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.floatValue();
            }
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.doubleValue();
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.bigDecimalValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return ((RAW)datum).shareBytes();
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.dateValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.timeValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.timestampValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                datum.asciiStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.binaryStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object = this.getObject(n2);
            return oracleDataFactory.create(object, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getObject(n2, this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return customDatumFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            return oRADataFactory.create(datum, 0);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string.equalsIgnoreCase("index")) {
                return 1;
            }
            if (string.equalsIgnoreCase("value")) {
                return 2;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                return datum.toJdbc();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.characterStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.bigDecimalValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                if (dATE != null) {
                    return dATE.dateValue(calendar);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                if (dATE != null) {
                    return dATE.timeValue(calendar);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                if (dATE != null) {
                    return dATE.timestampValue(calendar);
                }
            }
            return null;
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof NCLOB) {
                return (NCLOB)datum;
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return null;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof SQLXML) {
                return (SQLXML)((Object)datum);
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.currentIndex < 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.currentIndex > this.lastIndex;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.currentIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.currentIndex == this.lastIndex;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.currentIndex;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.fetchSize = n2 == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n2;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

