/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    Object value;
    int count;
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    AbstractStringBuilder() {
    }

    AbstractStringBuilder(int n) {
        this.value = StringValue.getCompressedStringsEnabled() ? (Object)new byte[n] : (Object)new char[n];
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return StringValue.array_length(this.value);
    }

    public void ensureCapacity(int n) {
        if (n > this.capacity()) {
            this.expandCapacity(n);
        }
    }

    void expandCapacity(int n) {
        int n2 = (this.capacity() + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        this.value = StringValue.is_byte_array(this.value) ? (Object)Arrays.copyOf((byte[])this.value, n2) : (Object)Arrays.copyOf((char[])this.value, n2);
    }

    void expandCapacity(boolean bl, int n) {
        int n2 = (this.capacity() + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        this.value = bl ? (Object)Arrays.copyOf((byte[])this.value, n2) : (Object)Arrays.copyOf((char[])this.value, n2);
    }

    public void trimToSize() {
        if (this.count < this.capacity()) {
            this.value = StringValue.is_byte_array(this.value) ? (Object)Arrays.copyOf((byte[])this.value, this.count) : (Object)Arrays.copyOf((char[])this.value, this.count);
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        boolean bl = StringValue.is_byte_array(this.value);
        if (n > this.capacity()) {
            this.expandCapacity(bl, n);
        }
        if (this.count < n) {
            if (bl) {
                while (this.count < n) {
                    ((byte[])this.value)[this.count] = 0;
                    ++this.count;
                }
            } else {
                while (this.count < n) {
                    ((char[])this.value)[this.count] = '\u0000';
                    ++this.count;
                }
            }
        } else {
            this.count = n;
        }
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (StringValue.is_byte_array(this.value)) {
            return (char)((byte[])this.value)[n];
        }
        return ((char[])this.value)[n];
    }

    public int codePointAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.codePointAt(cArray, n);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.codePointBefore(cArray, n);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.codePointCountImpl(cArray, n, n2 - n);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = StringValue.inflateValue(this.value);
        return Character.offsetByCodePointsImpl(cArray, 0, this.count, n, n2);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        char[] cArray2 = StringValue.inflateValue(this.value);
        System.arraycopy(cArray2, n, cArray, n3, n2 - n);
    }

    void copyChars(int n, int n2, char[] cArray, int n3) {
        StringValue.checkBounds(this.count, n, n2);
        StringValue.copyChars(this.value, n, cArray, n3, n2);
    }

    int copyBytes(int n, int n2, byte[] byArray, int n3) {
        StringValue.checkBounds(this.count, n, n2);
        return StringValue.copyBytes(this.value, n, byArray, n3, n2);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (StringValue.is_byte_array(this.value)) {
            if (c <= '\u007f') {
                ((byte[])this.value)[n] = (byte)c;
            } else {
                this.value = StringValue.inflateValue(this.value);
                ((char[])this.value)[n] = c;
            }
        } else {
            ((char[])this.value)[n] = c;
        }
    }

    private char fastCharAt(int n) {
        return StringValue.is_byte_array(this.value) ? (char)((byte[])this.value)[n] : ((char[])this.value)[n];
    }

    private void setFastCharAt(int n, char c) {
        if (StringValue.is_byte_array(this.value)) {
            ((byte[])this.value)[n] = (byte)c;
        } else {
            ((char[])this.value)[n] = c;
        }
    }

    public AbstractStringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public AbstractStringBuilder append(String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        if ((n = string.length()) == 0) {
            return this;
        }
        int n2 = this.count + n;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n2 > this.capacity()) {
            this.expandCapacity(bl, n2);
        }
        if (bl) {
            if (string.copyBytes(0, n, (byte[])this.value, this.count) == n) {
                this.count = n2;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        }
        string.copyChars(0, n, (char[])this.value, this.count);
        this.count = n2;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        int n = stringBuffer.length();
        int n2 = this.count + n;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n2 > this.capacity()) {
            this.expandCapacity(bl, n2);
        }
        if (bl) {
            if (stringBuffer.copyBytes(0, n, (byte[])this.value, this.count) == n) {
                this.count = n2;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        }
        stringBuffer.copyChars(0, n, (char[])this.value, this.count);
        this.count = n2;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public AbstractStringBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n < 0 || n2 < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException("start " + n + ", end " + n2 + ", s.length() " + charSequence.length());
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            return this;
        }
        int n4 = this.count + n3;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n4 > this.capacity()) {
            this.expandCapacity(bl, n4);
        }
        if (!bl) {
            for (int i = n; i < n2; ++i) {
                ((char[])this.value)[this.count++] = charSequence.charAt(i);
            }
        } else {
            boolean bl2 = false;
            for (int i = n; i < n2; ++i) {
                char c = charSequence.charAt(i);
                if (bl2 || c <= '\u007f') {
                    this.setFastCharAt(this.count++, charSequence.charAt(i));
                    continue;
                }
                this.value = StringValue.inflateValue(this.value);
                bl2 = true;
                ((char[])this.value)[this.count++] = charSequence.charAt(i);
            }
        }
        this.count = n4;
        return this;
    }

    public AbstractStringBuilder append(char[] cArray) {
        int n = this.count + cArray.length;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n > this.capacity()) {
            this.expandCapacity(bl, n);
        }
        if (bl) {
            if (StringValue.compressedCopy(cArray, 0, (byte[])this.value, this.count, cArray.length) == cArray.length) {
                this.count = n;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        }
        System.arraycopy(cArray, 0, (char[])this.value, this.count, cArray.length);
        this.count = n;
        return this;
    }

    public AbstractStringBuilder append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n3 > this.capacity()) {
            this.expandCapacity(bl, n3);
        }
        if (bl) {
            StringValue.checkBounds(cArray.length, n, n2);
            if (StringValue.compressedCopy(cArray, n, (byte[])this.value, this.count, n2) == n2) {
                this.count = n3;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        }
        System.arraycopy(cArray, n, (char[])this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder append(boolean bl) {
        boolean bl2 = StringValue.is_byte_array(this.value);
        if (bl) {
            int n = this.count + 4;
            if (n > this.capacity()) {
                this.expandCapacity(bl2, n);
            }
            if (bl2) {
                ((byte[])this.value)[this.count++] = 116;
                ((byte[])this.value)[this.count++] = 114;
                ((byte[])this.value)[this.count++] = 117;
                ((byte[])this.value)[this.count++] = 101;
            } else {
                ((char[])this.value)[this.count++] = 116;
                ((char[])this.value)[this.count++] = 114;
                ((char[])this.value)[this.count++] = 117;
                ((char[])this.value)[this.count++] = 101;
            }
        } else {
            int n = this.count + 5;
            if (n > this.capacity()) {
                this.expandCapacity(bl2, n);
            }
            if (bl2) {
                ((byte[])this.value)[this.count++] = 102;
                ((byte[])this.value)[this.count++] = 97;
                ((byte[])this.value)[this.count++] = 108;
                ((byte[])this.value)[this.count++] = 115;
                ((byte[])this.value)[this.count++] = 101;
            } else {
                ((char[])this.value)[this.count++] = 102;
                ((char[])this.value)[this.count++] = 97;
                ((char[])this.value)[this.count++] = 108;
                ((char[])this.value)[this.count++] = 115;
                ((char[])this.value)[this.count++] = 101;
            }
        }
        return this;
    }

    @Override
    public AbstractStringBuilder append(char c) {
        int n = this.count + 1;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n > this.capacity()) {
            this.expandCapacity(bl, n);
        }
        if (bl && c > '\u007f') {
            this.value = StringValue.inflateValue(this.value);
            bl = false;
        }
        if (bl) {
            ((byte[])this.value)[this.count++] = (byte)c;
        } else {
            ((char[])this.value)[this.count++] = c;
        }
        return this;
    }

    public AbstractStringBuilder append(int n) {
        if (n == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        int n2 = n < 0 ? AbstractStringBuilder.stringSizeOfInt(-n) + 1 : AbstractStringBuilder.stringSizeOfInt(n);
        int n3 = this.count + n2;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n3 > this.capacity()) {
            this.expandCapacity(bl, n3);
        }
        if (bl) {
            Integer.getBytes(n, n3, (byte[])this.value);
        } else {
            Integer.getChars(n, n3, (char[])this.value);
        }
        this.count = n3;
        return this;
    }

    static int stringSizeOfInt(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    public AbstractStringBuilder append(long l) {
        if (l == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        int n = l < 0L ? AbstractStringBuilder.stringSizeOfLong(-l) + 1 : AbstractStringBuilder.stringSizeOfLong(l);
        int n2 = this.count + n;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n2 > this.capacity()) {
            this.expandCapacity(bl, n2);
        }
        if (bl) {
            Long.getBytes(l, n2, (byte[])this.value);
        } else {
            Long.getChars(l, n2, (char[])this.value);
        }
        this.count = n2;
        return this;
    }

    static int stringSizeOfLong(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public AbstractStringBuilder append(float f) {
        new FloatingDecimal(f).appendTo((Appendable)this);
        return this;
    }

    public AbstractStringBuilder append(double d) {
        new FloatingDecimal(d).appendTo((Appendable)this);
        return this;
    }

    public AbstractStringBuilder delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (StringValue.is_byte_array(this.value)) {
                System.arraycopy((byte[])this.value, n + n3, (byte[])this.value, n, this.count - n2);
            } else {
                System.arraycopy((char[])this.value, n + n3, (char[])this.value, n, this.count - n2);
            }
            this.count -= n3;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int n) {
        int n2;
        if (!Character.isValidCodePoint(n)) {
            throw new IllegalArgumentException();
        }
        int n3 = 1;
        if (n >= 65536) {
            ++n3;
        }
        if ((n2 = this.count + n3) > this.capacity()) {
            this.expandCapacity(n2);
        }
        if (n3 > 1 || n > 127) {
            this.value = StringValue.inflateValue(this.value);
        }
        if (n3 == 1) {
            this.setFastCharAt(this.count++, (char)n);
        } else {
            Character.toSurrogates(n, (char[])this.value, this.count);
            this.count += n3;
        }
        return this;
    }

    public AbstractStringBuilder deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (StringValue.is_byte_array(this.value)) {
            System.arraycopy((byte[])this.value, n + 1, (byte[])this.value, n, this.count - n - 1);
        } else {
            System.arraycopy((char[])this.value, n + 1, (char[])this.value, n, this.count - n - 1);
        }
        --this.count;
        return this;
    }

    public AbstractStringBuilder replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        int n3 = string.length();
        int n4 = this.count + n3 - (n2 - n);
        boolean bl = StringValue.is_byte_array(this.value);
        if (n4 > this.capacity()) {
            this.expandCapacity(bl, n4);
        }
        if (bl) {
            System.arraycopy((byte[])this.value, n2, (byte[])this.value, n + n3, this.count - n2);
            if (string.copyBytes(0, n3, (byte[])this.value, n) == n3) {
                this.count = n4;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        } else {
            System.arraycopy((char[])this.value, n2, (char[])this.value, n + n3, this.count - n2);
        }
        string.copyChars(0, n3, (char[])this.value, n);
        this.count = n4;
        return this;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (StringValue.is_byte_array(this.value)) {
            return new String((byte[])this.value, n, n2 - n);
        }
        return new String((char[])this.value, n, n2 - n);
    }

    public AbstractStringBuilder insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n3 < 0 || n2 > cArray.length - n3) {
            throw new StringIndexOutOfBoundsException("offset " + n2 + ", len " + n3 + ", str.length " + cArray.length);
        }
        int n4 = this.count + n3;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n4 > this.capacity()) {
            this.expandCapacity(bl, n4);
        }
        if (bl) {
            System.arraycopy((byte[])this.value, n, (byte[])this.value, n + n3, this.count - n);
            if (StringValue.compressedCopy(cArray, n2, (byte[])this.value, n, n3) == n3) {
                this.count = n4;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        } else {
            System.arraycopy((char[])this.value, n, (char[])this.value, n + n3, this.count - n);
        }
        System.arraycopy(cArray, n2, (char[])this.value, n, n3);
        this.count = n4;
        return this;
    }

    public AbstractStringBuilder insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public AbstractStringBuilder insert(int n, String string) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.length();
        int n3 = this.count + n2;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n3 > this.capacity()) {
            this.expandCapacity(bl, n3);
        }
        if (bl) {
            System.arraycopy((byte[])this.value, n, (byte[])this.value, n + n2, this.count - n);
            if (string.copyBytes(0, n2, (byte[])this.value, n) == n2) {
                this.count = n3;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        } else {
            System.arraycopy((char[])this.value, n, (char[])this.value, n + n2, this.count - n);
        }
        string.copyChars(0, n2, (char[])this.value, n);
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder insert(int n, char[] cArray) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n3 > this.capacity()) {
            this.expandCapacity(bl, n3);
        }
        if (bl) {
            System.arraycopy((byte[])this.value, n, (byte[])this.value, n + n2, this.count - n);
            if (StringValue.compressedCopy(cArray, 0, (byte[])this.value, n, n2) == n2) {
                this.count = n3;
                return this;
            }
            this.value = StringValue.inflateValue(this.value);
        } else {
            System.arraycopy((char[])this.value, n, (char[])this.value, n + n2, this.count - n);
        }
        System.arraycopy(cArray, 0, (char[])this.value, n, n2);
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.insert(n, (String)charSequence);
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public AbstractStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n < 0 || n > this.length()) {
            throw new IndexOutOfBoundsException("dstOffset " + n);
        }
        if (n2 < 0 || n3 < 0 || n2 > n3 || n3 > charSequence.length()) {
            throw new IndexOutOfBoundsException("start " + n2 + ", end " + n3 + ", s.length() " + charSequence.length());
        }
        int n4 = n3 - n2;
        if (n4 == 0) {
            return this;
        }
        int n5 = this.count + n4;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n5 > this.capacity()) {
            this.expandCapacity(bl, n5);
        }
        if (bl) {
            System.arraycopy((byte[])this.value, n, (byte[])this.value, n + n4, this.count - n);
            for (int i = n2; i < n3; ++i) {
                char c = charSequence.charAt(i);
                if (bl && c > '\u007f') {
                    this.value = StringValue.inflateValue(this.value);
                    bl = false;
                }
                if (bl) {
                    ((byte[])this.value)[n++] = (byte)c;
                    continue;
                }
                ((char[])this.value)[n++] = c;
            }
        } else {
            System.arraycopy((char[])this.value, n, (char[])this.value, n + n4, this.count - n);
            for (int i = n2; i < n3; ++i) {
                ((char[])this.value)[n++] = charSequence.charAt(i);
            }
        }
        this.count = n5;
        return this;
    }

    public AbstractStringBuilder insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public AbstractStringBuilder insert(int n, char c) {
        int n2 = this.count + 1;
        boolean bl = StringValue.is_byte_array(this.value);
        if (n2 > this.capacity()) {
            this.expandCapacity(bl, n2);
        }
        if (bl && c > '\u007f') {
            this.value = StringValue.inflateValue(this.value);
            bl = false;
        }
        if (bl) {
            System.arraycopy((byte[])this.value, n, (byte[])this.value, n + 1, this.count - n);
            ((byte[])this.value)[n] = (byte)c;
        } else {
            System.arraycopy((char[])this.value, n, (char[])this.value, n + 1, this.count - n);
            ((char[])this.value)[n] = c;
        }
        this.count = n2;
        return this;
    }

    public AbstractStringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public AbstractStringBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public AbstractStringBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public AbstractStringBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return string.indexOf(this.value, 0, this.count, n);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        return string.lastIndexOf(this.value, 0, this.count, n);
    }

    public AbstractStringBuilder reverse() {
        char c;
        char c2;
        int n;
        boolean bl = false;
        int n2 = this.count - 1;
        for (n = n2 - 1 >> 1; n >= 0; --n) {
            c2 = this.fastCharAt(n);
            c = this.fastCharAt(n2 - n);
            if (!bl) {
                bl = c2 >= '\ud800' && c2 <= '\udfff' || c >= '\ud800' && c <= '\udfff';
            }
            this.setFastCharAt(n, c);
            this.setFastCharAt(n2 - n, c2);
        }
        if (bl) {
            for (n = 0; n < this.count - 1; ++n) {
                c2 = this.fastCharAt(n);
                if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c = this.fastCharAt(n + 1))) continue;
                this.setFastCharAt(n++, c);
                this.setFastCharAt(n, c2);
            }
        }
        return this;
    }

    @Override
    public abstract String toString();

    final char[] getValue() {
        char[] cArray = StringValue.inflateValue(this.value);
        return cArray;
    }
}

